package Application::Model::Role::Has::IsMobileMediationBase;

use qbit;

use Application::Model::Role;

requires qw(is_mobile_mediation_from_generated_column);

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  add_field__is_mobile_mediation
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        is_mobile_mediation => {
            from_opts => $self->is_mobile_mediation_from_generated_column() ? 'db_generated' : 'from_hash',
            label     => d_gettext('Is Mobile Mediation'),
            type      => 'boolean',
            api       => 1,
            need_check => {
                optional => TRUE,
                type     => 'boolean',
            },
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {
        fields => {
            is_mobile_mediation => {
                (
                    $self->is_mobile_mediation_from_generated_column()
                    ? (type => 'boolean')
                    : (
                        type       => 'json',
                        value_type => 'boolean',
                      )
                ),
                label => d_gettext('Is Mobile Mediation')
            },
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{'is_mobile_mediation'} = TRUE;

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    delete($fields->{'is_mobile_mediation'});

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    if ($self->check_short_rights('add_field__is_mobile_mediation')) {
        $fields->{'is_mobile_mediation'} = TRUE;
    } else {
        delete($fields->{'is_mobile_mediation'});
    }

    return $fields;
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $opts->{'is_mobile_mediation'} //= 0;
}

TRUE;
