package Application::Model::Role::Has::Jingles;

use qbit;

use Application::Model::Role;

use PiConstants qw(
  $OVERLAY_TYPES
  );

our %JINGLE_FIELDS = (
    jingle_code_at_start     => {field => 'WrapperAds',   key => 'begin'},
    jingle_code_at_end       => {field => 'WrapperAds',   key => 'end'},
    jingle_code_before_promo => {field => 'WrapperPromo', key => 'begin'},
    call_promo_code          => {field => 'WrapperPromo', key => 'promo'},
);

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw (
                  edit_field__jingle_codes
                  view_field__jingle_codes
                  )
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        map {$_ => {from_opts => 'from_hash', type => 'string', need_check => {type => 'xml', optional => TRUE,}}}
          keys %JINGLE_FIELDS
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights("view_field__jingle_codes")) {
        $fields->{$_} = TRUE foreach keys %JINGLE_FIELDS;
    } else {
        delete($fields->{$_}) foreach keys %JINGLE_FIELDS;
    }

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    if ($self->check_short_rights("edit_field__jingle_codes")) {
        $fields->{$_} = TRUE foreach keys %JINGLE_FIELDS;
    }

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    unless (defined $obj->{type} && $OVERLAY_TYPES->{$obj->{type}}) {
        if ($self->check_short_rights("edit_field__jingle_codes")) {
            $fields->{$_} = TRUE foreach keys %JINGLE_FIELDS;
        }
    }

    return $fields;
}

sub get_need_update_in_bk_fields {
    my ($self) = @_;

    my $fields = {};

    $fields->{$_} = TRUE foreach keys %JINGLE_FIELDS;

    return $fields;
}

sub get_bk_block_data {
    my ($self, $block, $bk_data) = @_;

    foreach (keys %JINGLE_FIELDS) {
        $bk_data->{$JINGLE_FIELDS{$_}->{field}}->{$JINGLE_FIELDS{$_}->{key}} = $block->{$_} if defined $block->{$_};
    }

    return $bk_data;
}

TRUE;
