package Application::Model::Role::Has::Moderation;

use qbit;

use Application::Model::Role;
use PiConstants qw($MYSQL_MIN_DATETIME);

requires qw(
  get_structure_model_fields
  get_structure_model_filter
  hook_set_initialize_settings
  );

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        waiting_moderation => {
            api   => 1,
            db    => TRUE,
            label => d_gettext('Waiting moderation'),
            type  => 'string',
        },
        done_moderation => {
            api   => 1,
            db    => TRUE,
            label => d_gettext('Done moderation'),
            type  => 'string',
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {
        fields => {
            waiting_moderation => {type => 'date', label => d_gettext('Waiting moderation'),},
            done_moderation    => {type => 'date', label => d_gettext('Done moderation'),},
        },
    };
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $opts->{waiting_moderation} //= $MYSQL_MIN_DATETIME;
    $opts->{done_moderation}    //= $MYSQL_MIN_DATETIME;
}

sub on_action_approve {
    my ($self, $obj) = @_;

    $self->on_done_moderation($obj->{id});
}

sub on_action_reject {
    my ($self, $obj) = @_;

    $self->on_done_moderation($obj->{id});
}

sub on_done_moderation {
    my ($self, $id) = @_;

    $self->partner_db_table()->edit($id, {'done_moderation' => curdate('oformat' => 'db_time'),});
}

sub on_moderation_request_sent {
    my ($self, $data) = @_;

    my $pk_fields = $self->partner_db_table()->primary_key();
    my $pk_list = [map [@{$_}{@$pk_fields}], @$data];
    $self->partner_db_table()->edit($pk_list, {'waiting_moderation' => curdate('oformat' => 'db_time'),});

    return TRUE;
}

sub get_actions_depends {
    [qw(done_moderation)];
}

1;
