package Application::Model::Role::Has::Moderation::Site;

use qbit;

use Application::Model::Role;
use PiConstants qw($MYSQL_MIN_DATETIME);

consume qw(
  Application::Model::Role::Has::Moderation
  );

requires qw(
  can_action_return_to_moderation
  on_action_return_to_moderation
  );

sub can_action_return_to_moderation {
    my ($self, $obj) = @_;

    my $object = $self->_get_object_fields($obj, [qw(done_moderation moderation_timeout), keys %$obj]);

    return FALSE unless $object;
    if ($object->{moderation_timeout}) {
        return FALSE
          if $object->{moderation_timeout} < 0 || is_date_in_future(
            date_add(
                $object->{done_moderation},
                iformat => 'db_time',
                second  => $object->{moderation_timeout},
            )
          );
    }

    return TRUE;
}

sub on_action_return_to_moderation {
    my ($self, $obj, %opts) = @_;

    $self->partner_db_table()->edit($obj, {'waiting_moderation' => $MYSQL_MIN_DATETIME});
}

1;
