package Application::Model::Role::Has::ModerationReason::MobileApp;

use qbit;

use Application::Model::Role;

consume qw(
  Application::Model::Role::Has::ModerationReason
  );

requires qw(
  can_action_reject
  on_action_approve
  on_action_reject
  on_action_set_need_approve
  );

sub on_action_approve {
    my ($self, $page, %opts) = @_;

    $self->_on_positive_action($page, %opts);
}

sub can_action_reject {
    my ($self, $page, %opts) = @_;

    return $self->_can_negative_action($page, %opts);
}

sub on_action_reject {
    my ($self, $page, %opts) = @_;

    $self->_on_negative_action($page, %opts);
}

sub on_action_set_need_approve {
    my ($self, $obj, %opts) = @_;

    $self->_on_positive_action($obj, %opts);
}

TRUE;
