package Application::Model::Role::Has::ModerationReason::Page;

use qbit;

use Application::Model::Role;

consume qw(
  Application::Model::Role::Has::ModerationReason
  );

requires qw(
  can_action_reject
  can_action_set_blocked
  on_action_approve
  on_action_reject
  on_action_reset_blocked
  on_action_set_blocked
  on_action_set_need_approve
  );

sub on_action_approve {
    my ($self, $page, %opts) = @_;

    $self->_on_positive_action($page, %opts);
}

sub can_action_reject {
    my ($self, $page, %opts) = @_;

    return $self->_can_negative_action($page, %opts);
}

sub on_action_reject {
    my ($self, $page, %opts) = @_;

    $self->_on_negative_action($page, %opts);
}

sub on_action_reset_blocked {
    my ($self, $page, %opts) = @_;

    $self->_on_positive_action($page, %opts);
}

sub can_action_set_blocked {
    my ($self, $page, %opts) = @_;

    return $self->_can_negative_action($page, %opts);
}

sub on_action_set_blocked {
    my ($self, $page, %opts) = @_;

    $self->_on_negative_action($page, %opts);
}

sub on_action_set_need_approve {
    my ($self, $obj, %opts) = @_;

    $self->_on_positive_action($obj, %opts);
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    # on add copy moderation reasons from site to page
    # only for context pages, mobile page cannot be added with rejected ap
    if ($opts->{domain_id}) {
        my $site_moderation_reason =
          $self->site->get($opts->{domain_id}, fields => ['moderation_reason'])->{moderation_reason};
        if ($site_moderation_reason && @$site_moderation_reason) {
            if ($opts->{moderation_reason}) {
                push @{$opts->{moderation_reason}}, @$site_moderation_reason;
            } else {
                $opts->{moderation_reason} = $site_moderation_reason;
            }
        }
    }

    return TRUE;
}

TRUE;
