package Application::Model::Role::Has::ModerationReason::Users;

use qbit;

use Application::Model::Role;

consume qw(
  Application::Model::Role::Has::ModerationReason
  );

requires qw(
  can_action_set_blocked
  on_action_reset_blocked
  on_action_set_blocked
  );

sub on_action_reset_blocked {
    my ($self, $user, %opts) = @_;

    $self->_on_positive_action($user, %opts);
}

sub can_action_set_blocked {
    my ($self, $user, %opts) = @_;

    return $self->_can_negative_action($user, %opts);
}

sub on_action_set_blocked {
    my ($self, $user, %opts) = @_;

    $self->_on_negative_action($user, %opts);
}

TRUE;
