package Application::Model::Role::Has::MoneyMap;

use qbit;
use Application::Model::Role;

use Exception::Validator::Fields;
use Exception::MoneyMap;

requires qw(get_default_owner_login);

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  edit_field__moneymap
                  view_field__moneymap
                  ),
            }
        }
    ];
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('view_field__moneymap')) {
        $fields->{moneymap} = TRUE;
    } else {
        delete $fields->{moneymap};
    }
    return $fields;
}

sub get_add_fields {
    my ($self, $fields, $obj) = @_;

    if ($self->check_short_rights('edit_field__moneymap')) {
        $fields->{moneymap} = TRUE;
    }
    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('edit_field__moneymap')) {
        $fields->{moneymap} = TRUE;
    }
    return $fields;
}

sub get_fields_defaults {
    my ($self, $opts) = @_;

    my %need_fields = map {$_ => TRUE} @{$opts->{fields}};

    my $result = {};

    if ($need_fields{is_moneymap_required} && $self->check_short_rights('view_field__moneymap')) {
        my $page_owner_login = $self->get_default_owner_login() // $opts->{attributes}{login};
        throw Exception::Validation::BadArguments gettext('Missed required parameter "%s"', 'login')
          unless $page_owner_login;
        $result->{is_moneymap_required} = $self->app->api_moneymap->is_owner_internal($page_owner_login);
    }

    if ($need_fields{moneymap} && $self->check_short_rights('view_field__moneymap')) {
        $result->{moneymap} = $self->app->api_moneymap->get_fields($self->get_traffic_type());
    }

    return $result;
}

TRUE;
