package Application::Model::Role::Has::PICategories;

use qbit;

use Application::Model::Role;
use Partner::BlockPreset::Specification::PICategories;

use PiConstants qw($RTB_PRODUCT_TYPES $VIDEO_PRODUCT_TYPES $MAX_CPM $CPM_MULTIPLIER $BLOCKED_CPM_VALUE);

sub get_structure_model_accessors {
    return {
        picategories_dict => 'Application::Model::PICategoriesDict',
        picategories      => 'Application::Model::Product::PICategories',
    };
}

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  edit_field__picategories
                  ),
            }
        }
    ];
}

sub get_need_update_in_bk_fields {
    return {picategories => TRUE};
}

sub fix_type_for_picategories {
    my ($model, $value) = @_;

    for (@$value) {
        $_->{id} .= '';
        $_->{cpm} += 0;
    }

    return $value;
}

TRUE;
