package Application::Model::Role::Has::Page::FilterSelfDomain;
use qbit;

use Application::Model::Role;

my $FIELD_NAME    = 'filter_self_domain';
my $FIELD_LABLE   = d_gettext('Allow self domain');
my $DEFAULT_VALUE = TRUE;
my $BK_FIELD_NAME = 'AllowSelfDomain';
my $EDIT_RIGHT    = 'edit_field__' . $FIELD_NAME;
my $VIEW_RIGHT    = 'view_field__' . $FIELD_NAME;

requires qw(get_page_mirrors);

sub get_structure_rights_to_register {
    my ($self) = @_;
    return [{rights => {map {$self->get_description_right($_)} $EDIT_RIGHT, $VIEW_RIGHT,}}];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        $FIELD_NAME => {
            api       => 1,
            from_opts => 'from_hash',
            label     => $FIELD_LABLE,
            type      => 'boolean',
            get       => sub {
                $_[1]->{$FIELD_NAME} = ($_[1]->{$FIELD_NAME} // $DEFAULT_VALUE) ? 1 : 0;
                return $_[1]->{$FIELD_NAME};
            },
            need_check => {
                type     => 'boolean',
                optional => TRUE,
            },
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $self->app->delete_field_by_rights($fields, {$self->get_right($VIEW_RIGHT) => $FIELD_NAME,},);

    return $fields;
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    my $is_owner_internal = 1;
    unless ($self->is_internal_page()) {
        my $page_owner_login = $self->users->get($opts->{owner_id}, fields => ['login'])->{'login'};
        $is_owner_internal = $self->app->api_moneymap->is_owner_internal($page_owner_login);
    }

    $opts->{$FIELD_NAME} = ($is_owner_internal ? (not $DEFAULT_VALUE) : $DEFAULT_VALUE) ? 1 : 0;
}

sub get_bk_data {
    my ($self, $page, $data) = @_;

    if ($page->{$FIELD_NAME}) {
        my $mirrors = $self->get_page_mirrors($page);
        $data->{excluded_domains} = [sort @{array_uniq(@{$data->{excluded_domains}}, $page->{'domain'}, @$mirrors)}];
    }

    return %$data;
}

sub collect_editable_fields {
    my ($self, $data, $fields) = @_;

    $fields->{$FIELD_NAME} = TRUE if $self->check_short_rights($EDIT_RIGHT);

    return $fields;
}

1;
