package Application::Model::Role::Has::Page::Patch;

use qbit;

use Application::Model::Role;
use Utils::JSON qw(apply_json_patch);
use PiConstants qw($PAGE_KEYS_TRANSFORM);

consume qw(Application::Model::Role::Has::Patch);

sub apply_bk_data_patch {
    my ($self, $page, $bk_data) = @_;

    if ($page->{patch}) {
        # NOTE! $bk_data с полями модели (snaked_case), а патч задается для транспорта (CamelCase)
        my $delete_keys_transform = {reverse %$PAGE_KEYS_TRANSFORM};
        return apply_json_patch($bk_data, $page->{patch}, $delete_keys_transform);
    }

    return $bk_data;
}

sub fix_template {
    my ($self, $qv) = @_;

    my $template = $qv->template;
    my $fields   = $template->{'fields'};

    if ($fields->{'patch'}) {
        $fields->{'patch'}->{type} = 'page_patch';
        $fields->{'patch'}->{optional} = 0 if $qv->app->accessor() eq 'distribution_campaign' ? 1 : 0;
    }

    return 1;
}

TRUE;
