package Application::Model::Role::Has::PartnerReadOnly;

use qbit;

use Application::Model::Role;

requires qw(_partner_read_only_can_action);

my $FIELD_NAME = 'partner_read_only';
my $EDIT_RIGHT = 'edit_field__' . $FIELD_NAME;
my $VIEW_RIGHT = 'view_field__' . $FIELD_NAME;

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [{rights => {map {$self->get_description_right($_)} $EDIT_RIGHT, $VIEW_RIGHT,}}];
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {
        fields => {
            $FIELD_NAME => {
                label      => d_gettext('Closed from editing'),
                type       => 'json',
                value_type => 'boolean',
            }
        }
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $self->app->delete_field_by_rights($fields, {$self->get_right($VIEW_RIGHT) => $FIELD_NAME,},);

    return $fields;
}

sub get_actions_depends {
    [$FIELD_NAME];
}

sub can_action_edit {
    my ($self, $obj) = @_;

    return $self->_partner_read_only_can_action($obj);
}

sub can_action_delete {
    my ($self, $obj) = @_;

    return $self->_partner_read_only_can_action($obj);
}

sub can_action_restore {
    my ($self, $obj) = @_;

    return $self->_partner_read_only_can_action($obj);
}

1;
