package Application::Model::Role::Has::Patch;

use qbit;

use Application::Model::Role;

my $FIELD_NAME = 'patch';
my $EDIT_RIGHT = 'edit_field__' . $FIELD_NAME;
my $VIEW_RIGHT = 'view_field__' . $FIELD_NAME;

sub get_structure_rights_to_register {
    my ($self) = @_;
    return [{rights => {map {$self->get_description_right($_)} $EDIT_RIGHT, $VIEW_RIGHT,}}];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        patch => {
            db         => TRUE,
            label      => d_gettext('BK data patch'),
            type       => 'string',
            need_check => {
                type     => 'json',
                optional => TRUE,
            },
            get => sub {
                my ($model, $row) = @_;
                if ($row->{'patch'}) {
                    utf8::decode($row->{'patch'});
                    return to_json(from_json($row->{'patch'}), pretty => 1,);
                } else {
                    return $row->{'patch'};
                }
            },
            api => 1,
        }
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $self->app->delete_field_by_rights($fields, {$self->get_right($VIEW_RIGHT) => $FIELD_NAME,},);

    return $fields;
}

sub collect_editable_fields {
    my ($self, $data, $fields) = @_;

    $fields->{$FIELD_NAME} = TRUE if $self->check_short_rights($EDIT_RIGHT);

    return $fields;
}

sub hook_fields_processing_before_validation {
    my ($self, $opts) = @_;
    # Если прислали просто данные, в не json в json-е (удобно в TJSON тестах)
    if (ref $opts->{patch}) {
        $opts->{'patch'} = to_json($opts->{patch}, pretty => 1);
    }
}

sub get_need_update_in_bk_fields {
    return {$FIELD_NAME => 1};
}

1;
