package Application::Model::Role::Has::PlaceID;

use qbit;
use Application::Model::Role;

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  view_field__place_id
                  edit_field__place_id
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        place_id => {
            db         => TRUE,
            label      => d_gettext('Place ID'),
            type       => 'number',
            need_check => {
                type     => 'int_un',
                optional => TRUE,
            },
            api => 1,
        },
    };
}

sub get_structure_model_filter {
    return {fields => {place_id => {type => 'number', label => d_gettext('Place ID')}}};
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('view_field__place_id')) {
        $fields->{'place_id'} = TRUE;
    } else {
        delete($fields->{'place_id'});
    }

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    if ($self->check_short_rights('edit_field__place_id')) {
        $fields->{'place_id'} = TRUE;
    } else {
        delete($fields->{'place_id'});
    }

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if (($self->hook_stash->inited && !$self->hook_stash->get('current')->{'place_id'}) || !$obj->{place_id}) {
        $fields->{'place_id'} = TRUE if $self->check_short_rights('edit_field__place_id');
    } else {
        delete($fields->{'place_id'});
    }

    return $fields;
}

sub get_need_update_in_bk_fields {
    return {place_id => 1,};
}

sub get_bk_block_data {
    my ($self, $block, $bk_data) = @_;

    if (   $block->{is_mobile_mediation}
        && defined($block->{application}{owner}{adfox_info}[0])
        && defined($block->{place_id}))
    {
        $bk_data->{AdfoxOwnerID} = $block->{application}{owner}{adfox_info}[0]{id};
        $bk_data->{AdfoxPlaceID} = $block->{place_id};
    }

    return $bk_data;
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    if ($self->hook_stash->inited() && $self->hook_stash->mode('duplicate')) {
        delete($opts->{'place_id'});
    }
}

1;
