package Application::Model::Role::Has::Preload;

use qbit;

use Application::Model::Role;

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        preload => {
            from_opts  => 'from_hash',
            label      => d_gettext('Preload video'),
            type       => 'boolean',
            need_check => {type => 'boolean',},
            api        => 1,
        },
    };
}

sub get_add_fields {
    my ($self, $fields) = @_;

    $fields->{'preload'} = TRUE;

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{'preload'} = TRUE;

    return $fields;
}

sub get_need_update_in_bk_fields {
    my ($self) = @_;

    my $fields = {};

    $fields->{'preload'} = TRUE;

    return $fields;
}

sub get_bk_block_data {
    my ($self, $block, $data) = @_;

    $data->{Video}->{Preload} = defined($block->{'preload'}) && $block->{'preload'} ? "1" : "0";

    return $data;
}

sub hook_fields_processing_before_validation {
    my ($self, $opts) = @_;

    $opts->{'preload'} //= 1 if $self->hook_stash->mode('add');

    $opts->{'preload'} += 0 if defined $opts->{'preload'} && looks_like_number($opts->{'preload'});
}

TRUE;
