package Application::Model::Role::Has::RTBDesignFields;

use qbit;

use Application::Model::Role;

use Exception::Validator::Fields;

requires qw(design_fields_from_opts);

sub get_structure_model_fields {
    my ($self) = @_;

    my $page_field_name         = $self->get_page_id_field_name();
    my $design_fields_from_opts = $self->design_fields_from_opts();

    return {
        direct_block => {
            db         => TRUE,
            label      => d_gettext('Direct block format'),
            type       => 'string',
            need_check => {
                check => sub {
                    my ($qv, $direct_block) = @_;

                    throw Exception::Validator::Fields gettext('Invalid direct block type')
                      unless defined($direct_block);

                    return TRUE if $qv->data->{'is_custom_format_direct'};

                    my %direct_blocks;
                    try {
                        %direct_blocks =
                          map {$_->{'id'} => $_} @{$qv->app->get_types_direct_blocks($qv->data)};
                    }
                    catch Exception::Validation::BadArguments with {
                        my ($exception) = @_;

                        throw Exception::Validator::Fields $exception;
                    };

                    throw Exception::Validator::Fields gettext('Invalid direct block type')
                      unless $direct_blocks{$direct_block};
                },
            },
            api => 1,
        },
        limit => {
            ($design_fields_from_opts ? (from_opts => 'from_hash',) : (db => TRUE,)),
            label      => d_gettext('Ads limit'),
            type       => 'number',
            need_check => {
                type  => 'int_un',
                check => sub {
                    my ($qv, $limit) = @_;

                    throw Exception::Validator::Fields gettext('Invalid limit')
                      unless defined($limit) && looks_like_number($limit) && $limit =~ /^[0-9]+$/;

                    my $direct_block = $qv->data->{'direct_block'}
                      // throw Exception::Validator::Fields gettext('"limit" depends on "direct_block"');

                    my %direct_blocks;
                    try {
                        %direct_blocks =
                          map {$_->{'id'} => $_} @{$qv->app->get_types_direct_blocks($qv->data)};
                    }
                    catch Exception::Validation::BadArguments with {
                        throw Exception::Validator::Fields $_[0];
                    };

                    throw Exception::Validator::Fields gettext('Invalid limit')
                      unless $direct_blocks{$direct_block}
                          && $direct_blocks{$direct_block}->{'min_banners'}
                          && $limit >= $direct_blocks{$direct_block}->{'min_banners'}
                          && $direct_blocks{$direct_block}->{'max_banners'}
                          && $limit <= $direct_blocks{$direct_block}->{'max_banners'}
                          || $qv->data->{'is_custom_format_direct'};
                },
            },
            api => 1,
        },
        adaptive_width => {
            (
                $design_fields_from_opts
                ? (
                    from_opts => 'from_hash',
                    get       => sub {
                        $_[1]->{'adaptive_width'} // '';
                    },
                  )
                : (db => TRUE,)
            ),
            label      => d_gettext('Adaptive block. width'),
            type       => 'string',
            need_check => {type => 'adaptive_width'},
            api        => 1,
        },
        adaptive_height => {
            (
                $design_fields_from_opts
                ? (
                    from_opts => 'from_hash',
                    get       => sub {
                        $_[1]->{'adaptive_height'} // '';
                    },
                  )
                : (db => TRUE,)
            ),
            label      => d_gettext('Adaptive block. height'),
            type       => 'string',
            need_check => {type => 'adaptive_height'},
            api        => 1,
        },
        callouts => {
            ($design_fields_from_opts ? (from_opts => 'from_hash',) : (db => TRUE,)),
            type       => 'boolean',
            need_check => {type => 'boolean',},
            api        => 1,
        },
    };
}

TRUE;
