package Application::Model::Role::Has::Readonly;

use qbit;
use Application::Model::Role;
use Exception::Validator::Fields;

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  edit_field__readonly
                  view_field__readonly
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        readonly => {
            from_opts  => 'from_hash',
            type       => 'boolean',
            api        => 1,
            need_check => {type => 'boolean', optional => TRUE},
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $self->app->delete_field_by_rights($fields, {$self->get_right('view_field__readonly') => 'readonly',});
    return $fields;
}

sub get_actions_depends {
    [qw(readonly)];
}

sub get_add_fields {
    my ($self, $fields) = @_;

    $fields->{readonly} = TRUE;

    $self->app->delete_field_by_rights($fields, {$self->get_right('edit_field__readonly') => 'readonly',});
    return $fields;
}

sub can_action_edit {
    my ($self, $obj) = @_;
    return $self->_can_action($obj);
}

sub can_action_delete {
    my ($self, $obj) = @_;
    return $self->_can_action($obj);
}

sub can_action_restore {
    my ($self, $obj) = @_;
    return $self->_can_action($obj);
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{readonly} = TRUE;
    $self->app->delete_field_by_rights($fields, {$self->get_right('edit_field__readonly') => 'readonly',});
    return $fields;
}

sub _can_action {
    my ($self, $obj) = @_;
    return FALSE
      if (!$self->check_short_rights('edit_field__readonly')
        && $self->_get_object_fields($obj, ['readonly'])->{readonly});
    return TRUE;
}

TRUE;
