package Application::Model::Role::Has::SendTime;

use qbit;

use Application::Model::Role;

use PiConstants qw( $MYSQL_DEFAULT_DATETIME );

sub get_structure_model_fields {
    my ($self) = @_;

    return {send_time => {db => TRUE, label => d_gettext('Time applying updates'), type => 'string',},};
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {fields => {send_time => {type => 'date', label => d_gettext('Time applying updates')},},};
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $opts->{'send_time'} = $MYSQL_DEFAULT_DATETIME;
}

TRUE;
