package Application::Model::Role::Has::Strategies;

use qbit;

use Application::Model::Role;

use Partner::BlockPreset::Specification::Strategies;

use Exception::Validator::Fields;

use PiConstants qw(
  $MIN_CPM_STRATEGY_ID
  $MAX_REVENUE_STRATEGY_ID
  $SEPARATE_CPM_STRATEGY_ID
  );

#{
#    $MAX_REVENUE_STRATEGY_ID  => [],
#    $SEPARATE_CPM_STRATEGY_ID => [qw(media text)]
#}
requires qw(get_strategies storage_method_of_strategies);

my $STRATEGIES_SPECIFICATION = {};

sub get_strategies_specification {
    my ($self, %opts) = @_;

    if ($self->can('_get_strategies_specification')) {
        return $self->_get_strategies_specification(%opts);
    } else {
        return $STRATEGIES_SPECIFICATION->{$self->accessor} //=
          Partner::BlockPreset::Specification::Strategies->new(specification => $self->get_strategies());
    }
}

#TODO: используется фронтом (удалить когда фронт перейдет на JSONAPI)
sub get_types_strategies {
    my ($self, $obj) = @_;

    return $self->get_strategies_specification->get_strategies_types($self, $obj);
}

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  edit_field__strategy
                  )
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    my $page_field_name = $self->get_page_id_field_name();

    my $strategies          = $self->get_strategies();
    my $validation_template = $self->get_strategies_specification->get_validation_template();

    #TODO: хранить одинаково во всех моделях
    my $storage_method = $self->storage_method_of_strategies();
    throw Exception 'Wrong type of storage method for strategies'
      unless grep {$_ eq $storage_method} qw(opts db);

    my %from = $storage_method eq 'opts' ? (from_opts => 'from_hash') : (db => TRUE);

    return {
        # TODO: Json schema???
        strategy => {
            %from,
            label       => d_gettext('Stategy'),
            type        => 'number',
            need_check  => $validation_template->{'strategy'},
            api         => 1,
            adjust_type => 'str',
        },
        strategy_name => {
            depends_on => [qw(strategy)],
            get        => sub {
                return $_[0]->{'__STRATEGY_NAMES__'}{$_[1]->{'strategy'}};
            },
            type => 'string',
        },
        (
            $strategies->{$MIN_CPM_STRATEGY_ID}
            ? (
                mincpm => {
                    %from,
                    label       => d_gettext('Min CPM'),
                    type        => 'number',
                    need_check  => $validation_template->{'mincpm'},
                    api         => 1,
                    adjust_type => 'str',
                }
              )
            : ()
        ),
        (
            $strategies->{$SEPARATE_CPM_STRATEGY_ID} ? map {
                (
                    "${_}_active" => {
                        %from,
                        type        => 'boolean',
                        need_check  => $validation_template->{"${_}_active"},
                        api         => 1,
                        adjust_type => 'str',
                    },
                    "${_}_blocked" => {
                        %from,
                        type        => 'boolean',
                        need_check  => $validation_template->{"${_}_blocked"},
                        api         => 1,
                        adjust_type => 'str',
                    },
                    "${_}_cpm" => {
                        %from,
                        type        => 'number',
                        need_check  => $validation_template->{"${_}_cpm"},
                        api         => 1,
                        adjust_type => 'str',
                    },
                )
              } @{$strategies->{$SEPARATE_CPM_STRATEGY_ID}{'fields'}}
            : ()
        ),
    };
}

sub pre_process_fields {
    my ($self, $fields, $result) = @_;

    if ($fields->need('strategy_name')) {
        $fields->{'__STRATEGY_NAMES__'} =
          {map {$_->{'id'} => $_->{'name'}} @{$self->get_strategies_specification->get_strategies_types($self)}};
    }
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    my $strategies = $self->get_strategies_specification()->get_strategies_types_as_hash($self, $obj);

    $fields = $self->_set_fields($strategies, $fields);

    return $fields;
}

sub get_add_fields {
    my ($self, $fields, $data) = @_;

    if ($self->check_short_rights('edit_field__strategy')) {
        my $strategies_specification = $self->get_strategies_specification();

        my $strategies;
        # TODO: remove this hack when frontend stops sending
        # percent_traffic, media_, text_ fields with undef's
        # for rewarded block
        if ($self->hook_stash->inited && $self->hook_stash->mode('add')) {
            $strategies = $strategies_specification->get_strategies_types_as_hash($self);
        } else {
            #TODO: фронт должен передавать хэш а не строку
            if ($self->accessor eq 'internal_mobile_app_rtb' && ref($data) eq '') {
                $data = {block_type => $data};
            }

            $strategies = $strategies_specification->get_strategies_types_as_hash($self, $data);
        }

        $fields = $self->_set_fields($strategies, $fields);
    }

    return $fields;
}

sub get_need_update_in_bk_fields {
    my ($self) = @_;

    my $strategies = $self->get_strategies_specification->get_strategies_types_as_hash($self);

    return $self->_set_fields($strategies, {});
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('edit_field__strategy')) {
        my $strategies = $self->get_strategies_specification()->get_strategies_types_as_hash($self, $obj);

        $fields = $self->_set_fields($strategies, $fields);
    }

    return $fields;
}

sub _set_fields {
    my ($self, $strategies, $fields) = @_;

    $fields->{'strategy'} = TRUE;

    if ($strategies->{$MIN_CPM_STRATEGY_ID}) {
        $fields->{'mincpm'} = TRUE;
    }

    if ($strategies->{$SEPARATE_CPM_STRATEGY_ID}) {

        foreach (@{$strategies->{$SEPARATE_CPM_STRATEGY_ID}}) {
            $fields->{$_} = TRUE;
        }
    }

    return $fields;
}

sub fix_template {
    my ($self, $qv) = @_;

    my $pre_run = $self->get_strategies_specification->get_validation_pre_run();

    $pre_run->($qv);
}

sub hook_fields_processing_before_validation {
    my ($self, $opts) = @_;

    my $old_settings = $self->hook_stash->get('current');
    my $new_settings = $self->hook_stash->get('settings');

    return unless defined $new_settings->{'strategy'};

    my $strategies = $self->get_strategies();

    if ($new_settings->{'strategy'} ne $SEPARATE_CPM_STRATEGY_ID) {
        foreach (@{$strategies->{$SEPARATE_CPM_STRATEGY_ID}{'fields'}}) {
            $opts->{"${_}_active"}  //= undef;
            $opts->{"${_}_blocked"} //= undef;
            $opts->{"${_}_cpm"}     //= undef;
        }
    }

    if ($new_settings->{'strategy'} ne $MIN_CPM_STRATEGY_ID) {
        $opts->{'mincpm'} //= undef;
    }
}

TRUE;
