package Application::Model::Role::Has::Strategies::ShiftingFields;

use qbit;

use Application::Model::Role;

use Partner::BlockPreset::Specification::Strategies;

use Exception::Validator::Fields;

consume qw(Application::Model::Role::Has::Strategies);

use PiConstants qw(
  $MIN_CPM_STRATEGY_ID
  $MAX_REVENUE_STRATEGY_ID
  $SEPARATE_CPM_STRATEGY_ID
  );

sub _get_strategies_specification {
    my ($self, %opts) = @_;

    return Partner::BlockPreset::Specification::Strategies->new(specification => $self->get_strategies(%opts));
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    my $strategies =
      $self->_get_strategies_specification(%$obj, is_video_applicable => $obj->{show_video} ? 1 : 0)
      ->get_strategies_types_as_hash($self, $obj);

    $fields = $self->__set_fields($strategies, $fields, $obj);

    return $fields;
}

sub get_available_fields_depends {[qw(page show_video)]}

sub get_editable_fields_depends {[qw(page)]}

sub get_add_fields {
    my ($self, $fields, $data) = @_;

    if ($self->check_short_rights('edit_field__strategy')) {
        my %obj = 'HASH' eq ref $data ? %$data : ();

        my $is_video_applicable = $obj{show_video}
          && $self->is_show_video_applicable(\%obj)->{applicable};
        my $strategies_specification =
          $self->_get_strategies_specification(%obj, is_video_applicable => $is_video_applicable);
        #TODO: фронт должен передавать хэш а не строку
        if ($self->accessor eq 'internal_mobile_app_rtb' && ref($data) eq '') {
            %obj = (block_type => $data);
        }

        my $strategies = $strategies_specification->get_strategies_types_as_hash($self, \%obj);
        $fields = $self->__set_fields($strategies, $fields, \%obj);
    }

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('edit_field__strategy')) {
        my $is_video_applicable = $self->is_show_video_applicable($obj)->{applicable};

        my $strategies =
          $self->_get_strategies_specification(%$obj, is_video_applicable => $is_video_applicable)
          ->get_strategies_types_as_hash($self, $obj);

        $fields = $self->__set_fields($strategies, $fields, $obj);
    }

    return $fields;
}

sub __set_fields {
    my ($self, $strategies, $fields, $obj) = @_;

    $fields->{'strategy'} = TRUE;

    if ($strategies->{$MIN_CPM_STRATEGY_ID}) {
        $fields->{'mincpm'} = TRUE;
    }

    if ($strategies->{$SEPARATE_CPM_STRATEGY_ID}) {
        foreach my $field ($self->get_seperate_cpm_strategy_fields()) {
            delete $fields->{$field};
        }

        foreach (@{$strategies->{$SEPARATE_CPM_STRATEGY_ID}}) {
            $fields->{$_} = TRUE;
        }
    }

    return $fields;
}

sub hook_fields_processing_before_validation {
    my ($self, $opts) = @_;

    my $old_settings = $self->hook_stash->get('current');
    my $new_settings = $self->hook_stash->get('settings');

    return unless defined $new_settings->{'strategy'};

    my $strategies = $self->get_strategies(%$opts);

    if ($new_settings->{'strategy'} ne $SEPARATE_CPM_STRATEGY_ID) {
        foreach ($self->get_seperate_cpm_strategy_fields()) {
            $opts->{"${_}_active"}  //= undef;
            $opts->{"${_}_blocked"} //= undef;
            $opts->{"${_}_cpm"}     //= undef;
        }
    } else {
        # for video_active, _blocked, _cpm to not break api
        if (defined $opts->{'strategy'}) {
            foreach (
                $self->get_non_applicable_seperate_cpm_strategy_fields({%$opts, (page_id => $old_settings->{page_id})}))
            {
                $opts->{$_} //= undef;
            }
        }

        # strategy will become invalid, video_active should be defined when show_video = 1
        if (!$old_settings->{show_video} && $new_settings->{show_video} && !defined $new_settings->{video_active}) {
            $opts->{'video_active'} = 0;
        } elsif ($old_settings->{show_video} && !$new_settings->{show_video}) {
            # if text and media are both blocked - set strategy to MAX_REVENUE
            # if not - unset video_* fields
            my %patch = %{$self->get_strategy_patch_on_show_video_off($new_settings)};
            $opts->{$_} = $patch{$_} for (keys %patch);
        }

    }

    if ($new_settings->{'strategy'} ne $MIN_CPM_STRATEGY_ID) {
        $opts->{'mincpm'} //= undef;
    }
}

sub get_non_applicable_seperate_cpm_strategy_fields {
    my ($self, $obj) = @_;

    my %got_fields = map {$_ => 1} $self->get_seperate_cpm_strategy_fields($obj);
    return grep {!exists $got_fields{$_}} $self->get_seperate_cpm_strategy_fields();
}

sub get_seperate_cpm_strategy_fields {
    my ($self, $obj) = @_;

    my %obj = 'HASH' eq ref $obj ? %$obj : ();
    # with page_id should check feature first and pass it
    if ($obj{page_id}) {
        my $is_video_applicable = $obj->{show_video};
        return $self->_get_strategies_specification()
          ->get_seperate_cpm_strategy_fields($self->get_ad_type_list(is_video_applicable => $is_video_applicable));
        # with no page_id should return all types, no matter what
    } else {
        return $self->_get_strategies_specification()->get_seperate_cpm_strategy_fields($self->get_ad_type_list());
    }
}

sub get_strategy_patch_on_show_video_off {
    my ($self, $block) = @_;

    my %patch;
    if ($SEPARATE_CPM_STRATEGY_ID == $block->{strategy}) {
        if (($block->{text_blocked} && $block->{media_blocked}) || (!($block->{text_active} || $block->{media_active})))
        {
            %patch = (
                strategy => $MAX_REVENUE_STRATEGY_ID,
                (
                    map {$_ => undef}
                      $self->_get_strategies_specification()
                      ->get_seperate_cpm_strategy_fields($self->get_ad_type_list())
                )
            );
        } else {
            %patch = (
                strategy => $SEPARATE_CPM_STRATEGY_ID,
                (
                    map {$_ => undef}
                      $self->_get_strategies_specification()->get_seperate_cpm_strategy_fields([qw(video)])
                )
            );
        }
    }
    return \%patch;
}

TRUE;
