package Application::Model::Role::Has::Strategies::WithFilters;

use qbit;

use Application::Model::Role;

use PiConstants qw(
  $MIN_CPM_STRATEGY_ID
  $MAX_REVENUE_STRATEGY_ID
  $SEPARATE_CPM_STRATEGY_ID
  );

consume qw(Application::Model::Role::Has::Strategies);

my %separate_cpm_label = (
    text_cpm      => d_gettext('Text CPM'),
    text_blocked  => d_gettext('Text blocked'),
    media_cpm     => d_gettext('Media CPM'),
    media_blocked => d_gettext('Media blocked'),
    video_cpm     => d_gettext('Video CPM'),
    video_blocked => d_gettext('Video blocked'),
    # TODO: video, video-performance
);

sub get_structure_model_filter {
    my ($self) = @_;

    return {fields => $self->_strategy_model_filters(),};
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    my $filters = $self->_strategy_model_filters();
    return [map {+{name => $_, label => $filters->{$_}{label}->(), group => 'strategy_parameters'}}
        sort keys(%$filters),
    ];
}

sub _strategy_model_filters {
    my ($self) = @_;

    my $strategies = $self->get_strategies();
    my $types_strategies_hash = {map {$_->{id} => $_} @{$self->get_types_strategies()}};

    return {
        strategy => {
            type   => 'dictionary',
            label  => d_gettext('Strategy'),
            values => sub {
                return [
                    map {+{id => $_->{id}, label => $_->{name},}}
                    sort {$a->{'id'} <=> $b->{'id'}} values(%$types_strategies_hash),
                ];
            },
        },
        (
            $strategies->{$MIN_CPM_STRATEGY_ID}
            ? (
                mincpm => {
                    type  => 'number',
                    label => d_gettext('Minimum CPM'),
                },
              )
            : ()
        ),
        (
            $strategies->{$SEPARATE_CPM_STRATEGY_ID} ? map {
                (
                    # TODO: labels
                    "${_}_blocked" => {
                        type  => 'boolean',
                        label => $separate_cpm_label{"${_}_blocked"},
                    },
                    "${_}_cpm" => {
                        type  => 'number',
                        label => $separate_cpm_label{"${_}_cpm"},
                    },
                )
              } @{$strategies->{$SEPARATE_CPM_STRATEGY_ID}{'fields'}}
            : ()
        ),
    };
}

TRUE;
