package Application::Model::Role::Has::Tags;

use qbit;
use Application::Model::Role;
use Exception::Validator::Fields;

my @TAG_TYPE = (
    {name => 'order_tags',  bk_name => 'OrderTags',  label => d_gettext('Order tags'),},
    {name => 'target_tags', bk_name => 'TargetTags', label => d_gettext('Target tags'),},
);

=head
    {
        '1' => { id => 1, name => 'tag_string_id1', descr => 'tag actual value1' },
        '2' => { id => 2, name => 'tag_string_id2', descr => 'tag actual value2' },
    }
=cut

my $TAG_LIST = {};

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  edit_field__order_tags
                  view_field__order_tags
                  edit_field__target_tags
                  view_field__target_tags
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        map {
            $_->{name} => {
                from_opts  => 'from_hash',
                label      => $_->{label},
                type       => 'array',
                sub_type   => 'number',
                api        => 1,
                need_check => {
                    optional => TRUE,
                    type     => 'array',
                    check    => sub {
                        my ($qv, $tag_id_list) = @_;
                        my @nonexistent_tag_id_list = grep {!exists $qv->app->get_tag_list()->{$_}} @$tag_id_list;
                        throw Exception::Validator::Fields gettext('Nonexistent tags: %s',
                            join(',', @nonexistent_tag_id_list))
                          if (@nonexistent_tag_id_list);
                      }
                },
              }
          } @TAG_TYPE
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    return _add_remove_tag_fields($self, $fields, 'view');
}

sub get_add_fields {
    my ($self, $fields) = @_;

    return _add_remove_tag_fields($self, $fields, 'edit');
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    return _add_remove_tag_fields($self, $fields, 'edit');
}

sub get_need_update_in_bk_fields {
    return {map {$_->{name} => 1} @TAG_TYPE};
}

sub _get_tag_list_for_bk {
    my ($self, $obj, $bk_data) = @_;

    $bk_data //= {};

    my $tag_list_hh = $self->get_tag_list();

    foreach my $tag_type (@TAG_TYPE) {
        # map our `id` -> Direct `name`
        push @{$bk_data->{$tag_type->{bk_name}}}, map {$tag_list_hh->{$_}->{name}} @{$obj->{$tag_type->{name}} // []};
    }

    return $bk_data;
}

sub _add_remove_tag_fields {
    my ($self, $fields, $right_to_check) = @_;

    foreach (@TAG_TYPE) {
        if ($self->check_short_rights($right_to_check . '_field__' . $_->{name})) {
            $fields->{$_->{name}} = TRUE;
        } else {
            delete($fields->{$_->{name}});
        }
    }

    return $fields;
}

sub get_tag_list {
    my ($self) = @_;

    unless (keys %$TAG_LIST) {
        $TAG_LIST = {map {$_->{id} => $_} @{$self->app->api_yt_partner_target_tags->get_target_tags()}};
    }

    return $TAG_LIST;
}

sub get_fields_defaults {
    my ($self, $opts) = @_;

    my %need_fields = map {$_ => TRUE} @{$opts->{fields}};

    my $result = {};

    if ($need_fields{'target_tags'}) {
        $result->{target_tags} = [
            map {{id => $_->{id}, descr => $_->{descr}}}
            sort {$a->{'id'} <=> $b->{'id'}} values %{$self->get_tag_list()}
        ];
    }

    return $result;
}

TRUE;
