package Application::Model::Role::Has::Tier;

use qbit;
use Application::Model::Role;

my $TIER_VALID_VALUES = [1, 2, 3, 4];

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  edit_field__tier
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        tier => {
            db         => TRUE,
            label      => d_gettext('Tier'),
            type       => 'number',
            api        => 1,
            need_check => {
                optional => TRUE,
                in       => $TIER_VALID_VALUES,
            },
            adjust_type => 'str',
        },
    };
}

sub get_structure_model_filter {
    return {
        fields => {
            tier => {
                type   => 'dictionary',
                label  => gettext('Tier'),
                values => sub {
                    return [
                        map +{
                            id    => $_,
                            label => $_,
                        },
                        @$TIER_VALID_VALUES
                    ];
                },
            },
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{'tier'} = TRUE;

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;
    my $accessor = $self->accessor();

    if ($self->check_short_rights('edit_field__tier') && !in_array($accessor, [qw(indoor outdoor)])) {
        $fields->{'tier'} = TRUE;
    } else {
        delete($fields->{'tier'});
    }
    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('edit_field__tier')) {
        $fields->{'tier'} = TRUE;
    } else {
        delete($fields->{'tier'});
    }

    return $fields;
}

TRUE;
