package Application::Model::Role::Has::UnmoderatedRtbAuction;

use qbit;

use Application::Model::Role;

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  view_field__unmoderated_rtb_auction
                  edit_field__unmoderated_rtb_auction
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        unmoderated_rtb_auction => {
            db         => TRUE,
            type       => 'boolean',
            api        => 1,
            need_check => {
                type     => 'boolean',
                optional => TRUE,
            },
            adjust_type => 'str',
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('view_field__unmoderated_rtb_auction')) {
        $fields->{unmoderated_rtb_auction} = 1;
    } else {
        delete $fields->{unmoderated_rtb_auction};
    }

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('edit_field__unmoderated_rtb_auction')) {
        $fields->{unmoderated_rtb_auction} = 1;
    } else {
        delete $fields->{unmoderated_rtb_auction};
    }

    return $fields;
}

sub get_need_update_in_bk_fields {
    return {unmoderated_rtb_auction => 1,};
}

sub get_bk_data {
    my ($self, $page, $data) = @_;

    if ($page->{'unmoderated_rtb_auction'}) {
        push(@{$data->{page_options}{Enable}}, 'unmoderated-rtb-auction');
    } else {
        push(@{$data->{page_options}{Disable}}, 'unmoderated-rtb-auction');
    }

    return %$data;
}

TRUE;
