package Application::Model::Role::Has::UpdateTime;

use qbit;

use Application::Model::Role;

sub get_structure_model_fields {
    my ($self) = @_;

    return {update_time =>
          {db => TRUE, need_check => {type => 'date', format => 'db_time'}, label => d_gettext('Update time')},
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {fields => {update_time => {type => 'date', label => d_gettext('Update time')},},};
}

sub hook_fields_processing_before_validation {
    my ($self, $opts) = @_;

    $opts->{'update_time'} = curdate(oformat => 'db_time');
}

TRUE;
