package Application::Model::Role::Page::AdFoxNotifier;

use qbit;

use Application::Model::Role;

consume qw(
  Application::Model::Role::Page::Has::HasMediationBlock
  );

sub hook_processing_after_update {
    my ($self, $opts) = @_;
    my ($old_caption, $page_id) = @{$self->hook_stash->get('current')}{qw/caption/, $self->get_page_id_field_name};
    my $has_mediation = $self->get({id => $page_id}, fields => ['has_mediation_block'])->{has_mediation_block};
    if ($has_mediation) {
        my $new_caption = $opts->{caption};
        if (defined($new_caption) && $new_caption ne $old_caption) {
            $self->app->api_adfox_graphql->update_page_name(
                page_id  => $page_id,
                new_name => $new_caption,
            );
        }
    }
}

sub on_action_start {
    shift()->_on_start_stop(TRUE, @_);
}

sub on_action_stop {
    shift()->_on_start_stop(FALSE, @_);
}

sub _on_start_stop {
    my ($self, $is_started, $obj) = @_;

    my $fields = $self->get($obj, fields => ['has_mediation_block', $self->get_page_id_field_name]);
    if ($fields->{has_mediation_block}) {
        $self->app->api_adfox_graphql->start_stop_page(
            page_id    => $fields->{$self->get_page_id_field_name},
            is_started => $is_started,
        );
    }
}

TRUE;
