package Application::Model::Role::Page::Has::AllowDirectVASTRequest;

use qbit;

use Application::Model::Role;

my $FIELD_NAME    = 'allow_direct_vast_request';
my $EDIT_RIGHT    = 'edit_field__' . $FIELD_NAME;
my $VIEW_RIGHT    = 'view_field__' . $FIELD_NAME;
my $BK_NAME       = 'sad';
my $DEFAULT_VALUE = 0;

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [{rights => {map {$self->get_description_right($_)} $EDIT_RIGHT, $VIEW_RIGHT,}}];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        $FIELD_NAME => {
            from_opts  => 'from_hash',
            type       => 'boolean',
            need_check => {
                optional => TRUE,
                type     => 'boolean',
            },
            api => 1
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    $self->app->delete_field_by_rights(
        $fields,
        {
            $self->get_right($EDIT_RIGHT) => $FIELD_NAME,
            $self->get_right($VIEW_RIGHT) => $FIELD_NAME,
        },
    );

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    $fields->{$FIELD_NAME} = TRUE if $self->check_short_rights($EDIT_RIGHT);

    return $fields;
}

sub collect_editable_fields {
    my ($self, $data, $fields) = @_;

    $fields->{$FIELD_NAME} = TRUE if $self->check_short_rights($EDIT_RIGHT);

    return $fields;
}

sub get_need_update_in_bk_fields {
    return {$FIELD_NAME => TRUE};
}

sub get_bk_data {
    my ($self, $page, $data) = @_;

    $data->{$BK_NAME} = $page->{$FIELD_NAME} ? 1 : 0;

    return %$data;
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $opts->{$FIELD_NAME} //= $DEFAULT_VALUE;
}

1;
