package Application::Model::Role::Page::Has::Assessor;

use qbit;

use Application::Model::Role;

requires qw(get_testing_tag);

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        is_assessor => {
            depends_on => [qw(owner)],
            label      => d_gettext('Assessor'),
            get        => sub {
                return $_[1]->{'owner'}{'is_assessor'};
            },
            type => 'boolean',
        },
    };
}

sub get_actions_depends {
    return [qw(is_assessor)];
}

sub can_action_stop_testing {
    my ($self, $obj) = @_;

    my $object = $self->_get_object_fields($obj, [qw(is_assessor)]);
    return !$object->{is_assessor};
}

sub get_bk_data {
    my ($self, $page, $data) = @_;

    if ($page->{is_assessor} and my $testing_tag = $self->get_testing_tag) {
        push @{$data->{OrderTags}}, $testing_tag;
    }

    return %$data;
}

TRUE;
