package Application::Model::Role::Page::Has::AssessorWithTestMode;

use qbit;

use Application::Model::Role;

consume qw(Application::Model::Role::Page::Has::Assessor);

sub get_editable_fields_depends {
    return [qw(is_assessor)];
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->hook_stash->inited) {
        if ($self->hook_stash->mode('edit') && $self->hook_stash->get('current')->{is_assessor}) {
            delete $fields->{is_in_testmode};
        }
    } else {
        delete $fields->{is_in_testmode} if $obj->{is_assessor};
    }

    return $fields;
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    if ($self->hook_stash->get('user')->{is_assessor}) {
        $opts->{is_in_testmode} = 1;
    }
}

TRUE;
