package Application::Model::Role::Page::Has::BlocksLimit;

use qbit;

use Application::Model::Role;

=head
Два поля, которые нужны для экшонов с блоками.
=cut

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        blocks_limit => {
            db         => TRUE,
            label      => d_gettext('Blocks limit on page'),
            type       => 'number',
            api        => 1,
            need_check => {
                optional => TRUE,
                type     => 'int_un',
            },
            adjust_type => 'str',
        },
        blocks_count => {
            db         => TRUE,
            label      => d_gettext('Blocks Count on page'),
            type       => 'number',
            api        => 1,
            need_check => {
                optional => TRUE,
                type     => 'int_un',
            },
            adjust_type => 'str',
        },
    };
}

TRUE;
