package Application::Model::Role::Page::Has::HasMediationBlock;

use qbit;

use Application::Model::Role;

sub get_structure_model_fields {
    my ($self) = @_;
    return {
        has_mediation_block => {
            depends_on => ['page_id'],
            get        => sub {
                my ($self, $obj) = @_;
                return ($self->{'__HAS_MEDIATION_BLOCK__'}{$obj->{'page_id'}} // 0) > 0;
            },
            type => 'boolean',
            api  => TRUE,
        },
    };
}

sub pre_process_fields {
    my ($self, $fields, $result) = @_;

    my $page_page_id_name = $self->get_page_id_field_name;
    my $page_ids = array_uniq(map {$_->{$page_page_id_name} // $_->{'page_id'} // ()} @$result);
    if ($fields->need('has_mediation_block')) {
        $fields->{'__HAS_MEDIATION_BLOCK__'} = {};
        my $block_page_id_name = $self->mobile_app_rtb->get_page_id_field_name();
        foreach (
            @{
                $self->partner_db->query->select(
                    table  => $self->mobile_app_rtb->partner_db_table(),
                    filter => [
                        'AND',
                        [
                            [$block_page_id_name => 'IN'     => \$page_ids],
                            [place_id            => 'IS NOT' => \undef],
                            [multistate => 'NOT IN' => \$self->mobile_app_rtb->get_multistates_by_filter('deleted')],
                            (
                                $self->mobile_app_rtb->is_block_table_with_multiple_models()
                                ? ['model', '=', \$self->mobile_app_rtb->accessor()]
                                : ()
                            )
                        ]
                    ],
                    fields => {
                        cnt                 => {count => ['id']},
                        $block_page_id_name => '',
                    },
                  )->group_by($block_page_id_name)->get_all()
            }
          )
        {
            my $page_id = $_->{$block_page_id_name};
            $fields->{'__HAS_MEDIATION_BLOCK__'}{$page_id} = $_->{cnt};
        }
    }
}

TRUE;
