package Application::Model::Role::Page::Has::IgnoreDomainCheck;

use qbit;

use Application::Model::Role;
use PiConstants qw($ALICE_SKILLS_BUNDLE_ID);

my $FIELD_NAME    = 'ignore_domain_check';
my $BK_FIELD_NAME = 'ignore-domain-check';
my $EDIT_RIGHT    = 'edit_field__' . $FIELD_NAME;
my $VIEW_RIGHT    = 'view_field__' . $FIELD_NAME;
my $DEFAULT_VALUE = 0;

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        $FIELD_NAME => {
            api        => 1,
            from_opts  => 'from_hash',
            label      => d_gettext('Ignore_domain_check'),
            need_check => {type => 'boolean', optional => TRUE},
            type       => 'boolean',
        },
    };
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $opts->{$FIELD_NAME} //= ($opts->{store_id} // '') eq $ALICE_SKILLS_BUNDLE_ID ? 1 : 0;
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights($VIEW_RIGHT)) {
        $fields->{$FIELD_NAME} = 1;
    } else {
        delete $fields->{$FIELD_NAME};
    }
    return $fields;
}

sub collect_editable_fields {
    my ($self, $data, $fields) = @_;

    $fields->{$FIELD_NAME} = TRUE if $self->check_short_rights($EDIT_RIGHT);

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    $fields->{$FIELD_NAME} = TRUE if $self->check_short_rights($EDIT_RIGHT);

    return $fields;
}

sub get_need_update_in_bk_fields {
    return {$FIELD_NAME => 1};
}

sub get_bk_data {
    my ($self, $page, $bk_data) = @_;

    if ($page->{$FIELD_NAME}) {
        push(@{$bk_data->{page_options}{Enable}}, $BK_FIELD_NAME);
    } else {
        push(@{$bk_data->{page_options}{Disable}}, $BK_FIELD_NAME);
    }

    return %$bk_data;
}

TRUE;
