package Application::Model::Role::Page::Has::MetricaCounters;

use qbit;

use Application::Model::Role;

my $MC_FIELD_NAME = 'metrica_counters';

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  view_field__metrica_counters
                  edit_field__metrica_counters
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        # Доп. счетчики которые пользователь завел сам (#PI-11321)
        metrica_counters => {
            db         => TRUE,
            type       => 'array',
            sub_type   => 'number',
            api        => 1,
            need_check => {
                type     => 'array',
                all      => {type => 'int_un'},
                optional => TRUE,
            },
            get => sub {
                $_[1]->{$MC_FIELD_NAME} ? from_json($_[1]->{$MC_FIELD_NAME}) : [];
            },
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {fields => {$MC_FIELD_NAME => {type => 'text'},}};
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('view_field__metrica_counters')) {
        $fields->{$MC_FIELD_NAME} = 1;
    } else {
        delete $fields->{$MC_FIELD_NAME};
    }

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('edit_field__metrica_counters') && !$obj->{is_read_only}) {
        $fields->{$MC_FIELD_NAME} = 1;
    } else {
        delete $fields->{$MC_FIELD_NAME};
    }

    return $fields;
}

TRUE;
