package Application::Model::Role::Page::Has::MobileAppMode;

use qbit;

use Application::Model::Role;

sub get_structure_rights_to_register {
    my ($self) = @_;

    return [
        {
            rights => {
                map {$self->get_description_right($_)}
                  qw(
                  view_field__mobile_app_mode
                  edit_field__mobile_app_mode
                  ),
            }
        }
    ];
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        mobile_app_mode => {
            db         => TRUE,
            type       => 'number',
            api        => 1,
            need_check => {
                type     => 'int_un',
                optional => TRUE,
            },
            adjust_type => 'str',
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('view_field__mobile_app_mode')) {
        $fields->{mobile_app_mode} = 1;
    } else {
        delete $fields->{mobile_app_mode};
    }

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->check_short_rights('edit_field__mobile_app_mode') && !$obj->{is_read_only}) {
        $fields->{mobile_app_mode} = 1;
    } else {
        delete $fields->{mobile_app_mode};
    }

    # is_read_only

    return $fields;
}

sub get_need_update_in_bk_fields {
    return {mobile_app_mode => 1,};
}
# Adapt this default for page
# sub hook_fields_processing_before_validation {
#     my ($self, $opts) = @_;
#
#     if ($self->hook_stash->mode('add')) {
#         $opts->{mobile_app_mode} //= 0;
#     }
# }

sub get_bk_data {
    my ($self, $page, $data) = @_;

    $data->{mobile_app_mode} = $page->{mobile_app_mode};

    return %$data;
}

TRUE;
