package Application::Model::Role::Page::Has::Moderation;

use qbit;

use Application::Model::Role;
use PiConstants qw($MYSQL_MIN_DATETIME);

requires qw(
  can_action_set_need_approve
  get_structure_model_fields
  );

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        is_remoderation_available => {
            api               => 1,
            forced_depends_on => ['multistate'],
            get               => sub {
                return !$_[0]->model->check_multistate_flag($_[1]->{multistate}, 'blocked')
                  && $_[0]->model->check_multistate_flag($_[1]->{multistate}, 'rejected');
            },
            type => 'boolean',
        },
        when_remoderation_available => {
            api        => 1,
            depends_on => ['is_remoderation_available', 'moderation_timeout', 'done_moderation'],
            get        => sub {
                return
                     $_[1]->{is_remoderation_available}
                  && defined($_[1]->{moderation_timeout})
                  && $_[1]->{moderation_timeout} != -1
                  ? date_add(
                    $_[1]->{done_moderation},
                    iformat => 'db_time',
                    oformat => 'db_time',
                    second  => $_[1]->{moderation_timeout},
                  )
                  : '';
            },
            type => 'string',
        },
    };
}

sub can_action_set_need_approve {
    my ($self, $obj) = @_;

    my $object = $self->_get_object_fields($obj, [qw(done_moderation moderation_timeout)]);

    return FALSE unless $object;
    if ($object->{moderation_timeout}) {
        return FALSE
          if $object->{moderation_timeout} < 0 || is_date_in_future(
            date_add(
                $object->{done_moderation},
                iformat => 'db_time',
                second  => $object->{moderation_timeout},
            )
          );
    }

    return TRUE;
}

1;
