package Application::Model::Role::Page::Has::Moderation::MobileApp;

use qbit;

use Application::Model::Role;

consume qw(
  Application::Model::Role::Page::Has::Moderation
  );

requires qw(
  get_structure_model_fields
  );

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        waiting_moderation => {
            api               => 1,
            forced_depends_on => ['application_id', 'mobile_app.waiting_moderation'],
            label             => d_gettext('Waiting moderation'),
            get               => sub {
                $_[0]->{'mobile_app'}->{$_[1]->{'application_id'}}{'waiting_moderation'};
            },
            type => 'string',
        },
        done_moderation => {
            api               => 1,
            forced_depends_on => ['application_id', 'mobile_app.done_moderation'],
            label             => d_gettext('Done moderation'),
            get               => sub {
                $_[0]->{'mobile_app'}->{$_[1]->{'application_id'}}{'done_moderation'};
            },
            type => 'string',
        },
    };
}

sub on_action_set_need_approve {
    my ($self, $obj, %opts) = @_;

    my $tmp_rights_to_view_field = $self->app->add_tmp_rights($self->get_right('view_field__application_id'));
    my $object                   = $self->_get_object_fields($obj, [qw(application_id)]);
    my $app                      = $self->mobile_app->get($object->{application_id}, fields => [qw(id multistate)]);

    if ($self->mobile_app->check_multistate_flag($app->{multistate}, 'rejected')) {
        my $tmp_rights_to_do_action = $self->app->add_tmp_rights('do_mobile_app_set_need_approve');
        $self->mobile_app->do_action($object->{application_id}, 'set_need_approve');
    }
}

1;
