package Application::Model::Role::Page::Has::Moderation::Site;

use qbit;

use Application::Model::Role;

consume qw(
  Application::Model::Role::Page::Has::Moderation
  );

requires qw(
  get_structure_model_fields
  );

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        waiting_moderation => {
            api               => 1,
            forced_depends_on => ['domain_id', 'site.waiting_moderation'],
            label             => d_gettext('Waiting moderation'),
            get               => sub {
                $_[0]->{'site'}->{$_[1]->{'domain_id'}}{'waiting_moderation'};
            },
            type => 'string',
        },
        done_moderation => {
            api               => 1,
            forced_depends_on => ['domain_id', 'site.done_moderation'],
            label             => d_gettext('Done moderation'),
            get               => sub {
                $_[0]->{'site'}->{$_[1]->{'domain_id'}}{'done_moderation'};
            },
            type => 'string',
        },
    };
}

sub on_action_set_need_approve {
    my ($self, $obj, %opts) = @_;

    my $tmp_rights_to_view_field = $self->app->add_tmp_rights($self->get_right('view_field__domain_id'));
    my $object                   = $self->_get_object_fields($obj, [qw(domain_id)]);
    my $site                     = $self->site->get($object->{domain_id}, fields => [qw(id multistate)]);

    if ($self->site->check_multistate_flag($site->{multistate}, 'rejected')) {
        my $tmp_rights_to_do_action = $self->app->add_tmp_rights('do_site_return_to_moderation');
        $self->site->do_action($object->{domain_id}, 'return_to_moderation');
    }
}

1;
