package Application::Model::Role::Page::Has::MoneyMap;

use qbit;
use Application::Model::Role;

use Exception::IncorrectParams;
use Exception::MoneyMap;

consume qw(Application::Model::Role::Has::MoneyMap);

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        moneymap => {
            api        => 1,
            db         => FALSE,
            label      => d_gettext('MoneyMap'),
            type       => 'complex',
            depends_on => [qw(page_id)],
            get        => sub {
                my ($fields, $obj) = @_;
                return $fields->{'__MONEYMAP__'}->{$obj->{page_id}} // {};
            },
            lazy => 1,
        },
    };
}

sub pre_process_fields {
    my ($self, $fields, $result) = @_;

    if ($fields->need('moneymap')) {
        my $page_ids = $fields->stash->{'page_ids'} //= array_uniq(map {$_->{'page_id'}} @$result);

        $fields->{'__MONEYMAP__'} = $fields->model->app->api_moneymap->get_pages_by_ids($page_ids, TRUE);
    }
}

sub hook_preparing_fields_to_save {
    my ($self, $opts) = @_;

    if (exists $opts->{moneymap} && $self->check_short_rights('edit_field__moneymap')) {
        my $page_id = $opts->{page_id} // $opts->{id};
        try {
            my $page_caption = $self->hook_stash->get('settings')->{caption};
            if (   $self->accessor eq 'internal_context_on_site_campaign'
                || $self->accessor eq 'internal_search_on_site_campaign')
            {
                $page_caption = $self->hook_stash->get('settings')->{domain};
            }
            my $login = $self->get_option('cur_user', {})->{login};
            if ($self->hook_stash->mode('add')) {
                $self->app->api_moneymap->add_page(
                    login         => $login,
                    page_caption  => $page_caption,
                    page_id       => $page_id,
                    opts_moneymap => $opts->{moneymap}
                );
            } elsif ($self->hook_stash->mode('edit')) {
                $page_id = $self->hook_stash->get('id')->{id};
                $self->app->api_moneymap->edit_page(
                    login         => $login,
                    page_caption  => $page_caption,
                    page_id       => $page_id,
                    opts_moneymap => $opts->{moneymap}
                );
            }
        }
        catch Exception::MoneyMap with {
            my ($e) = @_;
            throw Exception::IncorrectParams $e;
        };
    }
    return TRUE;
}

TRUE;
