package Application::Model::Role::Page::Has::PICategories;

use qbit;

use Application::Model::Role;
use Partner::BlockPreset::Specification::PICategories;

use PiConstants qw($MAX_CPM $CPM_MULTIPLIER $BLOCKED_CPM_VALUE);

consume qw(Application::Model::Role::Has::PICategories);

sub get_structure_model_fields {
    my ($self) = @_;

    my $specification       = Partner::BlockPreset::Specification::PICategories->new();
    my $validation_template = $specification->get_validation_template();

    return {
        picategories => {
            label      => d_gettext('PICategories data'),
            depends_on => ['page_id', 'id', 'picategories.category_id', 'picategories.cpm'],
            get        => sub {
                my ($fields, $row) = @_;
                return [map {+{id => $_->{category_id} . "", cpm => 9999}}
                      @{$fields->{'picategories'}{$row->{'page_id'}}}];
            },
            type       => 'complex',
            need_check => $validation_template->{'picategories'},
            fix_type   => \&fix_type_for_picategories,
            api        => 1,
        },
        has_picategories_settings => {
            depends_on => ['picategories'],
            get        => sub {
                return defined($_[1]->{'picategories'}) && @{$_[1]->{'picategories'}} > 0;
            },
            type => 'boolean',
            api  => 1,
        },
    };
}

sub get_available_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->page_owner_has_feature_simple_inapp($obj)) {
        $fields->{$_} = TRUE foreach (qw(picategories has_picategories_settings));
    } else {
        delete $fields->{$_} foreach (qw(picategories has_picategories_settings));
    }

    return $fields;
}

sub get_add_fields {
    my ($self, $fields) = @_;

    if ($self->has_feature_simple_inapp()) {
        $fields->{'picategories'} = TRUE if $self->check_short_rights('edit_field__picategories');
    } else {
        delete $fields->{$_} foreach (qw(picategories has_picategories_settings));
    }

    return $fields;
}

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    if ($self->page_owner_has_feature_simple_inapp($obj)) {
        $fields->{'picategories'} = TRUE if $self->check_short_rights('edit_field__picategories');
    } else {
        delete $fields->{$_} foreach (qw(picategories has_picategories_settings));
    }

    return $fields;
}

sub get_bk_data {
    my ($self, $page, $bk_data) = @_;

    if ($self->page_owner_has_feature_simple_inapp($page)) {
        my $iab_data = $self->picategories_dict->get_complete_category($page->{picategories});
        foreach my $id (keys %$iab_data) {
            delete $iab_data->{$id}->{currency};
            my $cpm = delete $iab_data->{$id}->{value};
            if ($cpm == $MAX_CPM * $CPM_MULTIPLIER) {
                $cpm = $BLOCKED_CPM_VALUE;
                $iab_data->{$id}->{AllProducts} = $cpm;
            }
        }

        $bk_data->{'PICategoryIAB'} = $iab_data;
    }

    return %$bk_data;
}

sub related_models {
    return {
        picategories => {
            accessor => 'picategories',
            filter   => sub {
                return {
                    page_id => array_uniq(map {$_->{'page_id'} // ()} @{$_[1]}),
                    block_id => 0
                };
            },
            key_fields => ['page_id'],
            value_type => 'array',
        },
    };
}

sub hook_save_fields_from_related_models {
    my ($self, $opts) = @_;

    if ($self->hook_stash->check('fields_from_related_models')
        and my $categories = $self->hook_stash->get('fields_from_related_models')->{'picategories'})
    {
        my %filter;
        @filter{'page_id', 'block_id'} = ($self->hook_stash->get('id')->{id}, 0);

        my $tmp_rights = $self->app->add_tmp_rights('picategories_edit');

        $self->picategories->replace(\%filter, $categories, ($self->hook_stash->mode('add') ? 'add' : 'edit'));
    }
}

TRUE;
