package Application::Model::Role::Page::Has::PartnerReadOnly;

use qbit;

use Application::Model::Role;

consume qw(Application::Model::Role::Has::PartnerReadOnly);

my $FIELD_NAME    = 'partner_read_only';
my $EDIT_RIGHT    = 'edit_field__' . $FIELD_NAME;
my $DEFAULT_VALUE = 0;

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        $FIELD_NAME => {
            api        => 1,
            from_opts  => 'from_hash',
            need_check => {type => 'boolean', optional => TRUE},
            type       => 'boolean',
        },
    };
}

sub get_add_fields {
    my ($self, $fields) = @_;

    $fields->{$FIELD_NAME} = TRUE if $self->check_short_rights($EDIT_RIGHT);

    return $fields;
}

sub collect_editable_fields {
    my ($self, $data, $fields) = @_;

    $fields->{$FIELD_NAME} = TRUE if $self->check_short_rights($EDIT_RIGHT);

    return $fields;
}

sub hook_set_initialize_settings {
    my ($self, $opts) = @_;

    $opts->{$FIELD_NAME} //= $DEFAULT_VALUE;
}

sub _partner_read_only_can_action {
    my ($self, $obj) = @_;

    return FALSE
      if (!$self->check_short_rights($EDIT_RIGHT)
        && $self->_get_object_fields($obj, [$FIELD_NAME])->{$FIELD_NAME});

    return TRUE;
}

1;
