package Application::Model::Role::Page::Has::SingleState;

use qbit;

use Application::Model::Role;

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        single_state => {
            forced_depends_on => ['multistate'],
            get               => sub {
                $_[0]->model->_multistate_to_single_state($_[1]->{multistate});
            },
            type => 'string',
            api  => TRUE,
        },
    };
}

sub _multistate_to_single_state {
    my ($self, $multistate) = @_;
    for my $single ($self->get_single_states()) {
        my $flags = $single->{flags};
        if (@$flags) {
            for (@$flags) {
                return $single->{id} if $self->check_multistate_flag($multistate, $_);
            }
        } else {
            return $single->{id};
        }
    }
}

sub _single_states_to_filter_strings {
    my ($self) = @_;
    my @result;
    my $prev_flags = [];
    for my $single ($self->get_single_states) {
        my @conds;
        for ([$prev_flags => 'not '], [$single->{flags} => '']) {
            my ($flags, $op) = @$_;
            if (@$flags) {
                my $str = join ' or ', @$flags;
                $str = "( $str )" if @$flags > 1;
                push @conds, $op . $str;
            }
        }
        push @$prev_flags, @{$single->{flags}};
        my $filter_str = join ' and ', @conds;
        push @result, ($single->{id} => $filter_str);
    }
    return @result;
}

my $single_state_multistates;

sub _init_single_state_multistates {
    my ($self) = @_;
    $single_state_multistates = {};
    my %filters = $self->_single_states_to_filter_strings;
    for (keys %filters) {
        $single_state_multistates->{$_} = $self->get_multistates_by_filter($filters{$_});
    }
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {
        fields => {
            single_state => {
                type      => 'dictionary',
                label     => d_gettext('Single_state'),
                db_filter => sub {
                    my ($self, $filter) = @_;
                    my ($op, $arg) = @$filter[1, 2];
                    if ($op eq '=' or $op eq '<>') {
                        $arg = [$arg] unless ref $arg;
                        my @multistates;
                        push @multistates, @{$single_state_multistates->{$_}} for @$arg;
                        return [multistate => $op, \\@multistates];
                    } elsif ($op eq 'IS' or $op eq 'IS NOT') {
                        return [multistate => $op => $arg];
                    }
                },
                values => sub {
                    my ($self) = @_;
                    return [map {{id => $_->{id}, label => $_->{label}->(),}} $self->get_single_states];
                  }
            }
        },
    };
}

TRUE;
