package Application::Model::ShortLink;

use qbit;

use base qw(Application::Model::DBManager::Base);

use Digest::MD5 qw();

use Exception::DB::DuplicateEntry;
use Exception::Validation::BadArguments;

sub accessor      {'short_link'}
sub db_table_name {'short_link'}

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB::ShortLink',);

__PACKAGE__->model_fields(
    id     => {db      => TRUE, pk => TRUE},
    uri    => {default => TRUE, db => TRUE},
    params => {default => TRUE, db => TRUE},
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {id => {type => 'number'},},
);

sub add {
    my ($self, $request_data) = @_;

    throw Exception::Validation::BadArguments gettext("Invalid value of parameter '%s'.", 'uri')
      unless $request_data->{'page_uri'} =~ m'^/\w+';

    my $id;
    try {
        $id = $self->partner_db_table()->add(
            {
                id           => $self->_generate_id($request_data),
                uri          => $request_data->{'page_uri'},
                params       => $request_data->{'params'},
                last_call_dt => curdate(oformat => 'db_time'),
            }
        );
    }
    catch Exception::DB::DuplicateEntry with {
        $id = $self->add($request_data);
    };

    return $id;
}

sub cleanup_unused {
    my ($self) = @_;

    $self->partner_db_table()
      ->delete(
        $self->partner_db->filter([last_call_dt => '<' => \date_sub(curdate, month => 1, oformat => 'db_time')]));
}

sub get {
    my ($self, $id) = @_;

    my $data = $self->SUPER::get($id);

    $self->partner_db_table()->edit($id, {last_call_dt => curdate(oformat => 'db_time'),}) if defined($data);

    return $data;
}

sub _generate_id {
    my ($self, $request_data) = @_;

    my @chars = ("A" .. "Z", "a" .. "z", 0 .. 9);
    return join('', map {$chars[rand(@chars)]} 1 .. 5);
}

TRUE;
