package Application::Model::Statistics::AdditionalIncome;

use qbit;

use base qw(Application::Model::Statistics::Hierarchy);

sub accessor {'statistics_additional_income'}

sub clickhouse_table_name {'statistics_additional_income'}

__PACKAGE__->model_accessors(
    partner_db => 'Application::Model::PartnerDB',
    users      => 'Application::Model::Users',
);

__PACKAGE__->register_rights(
    [
        {
            name        => 'right_charging_in_statistics',
            description => d_gettext('Rights for charging in statistics'),
            rights      => {
                statistics_additional_income_view => d_gettext('Right to view level "statistics_additional_income"'),
                statistics_additional_income_always_view =>
                  d_gettext('Right to view level "statistics_additional_income" always'),
                statistics_additional_income_view_field__login => d_gettext('Right to view field "login"'),
            }
        }
    ]
);

sub children {()}

sub entity_fields {
    my ($self) = @_;

    return [
        (
            $self->check_short_rights('view_field__login')
            ? {
                id    => 'login',
                label => gettext('Login'),
                ($self->check_rights('settings_cmd_ucard') ? (type => 'login') : ())
              }
            : ()
        )
    ];
}

sub dimension_fields {
    my ($self) = @_;

    return {date => {}, currency_id => {}};
}

# Ф-ция вовращает список полей по которым можо фильтровать СОБЫТИЯ в соответствии с текущим уровнем
sub get_event_fields {
    my ($self) = @_;
    return [];    # события для этого уровня отсутствуют
}

sub sort_priority {70;}

sub title {gettext('Additional income')}

sub is_available {$_[0]->check_rights('statistics_additional_income_view')}

sub get_clickhouse_expressions {
    my ($self) = @_;

    return {
        %{$self->SUPER::get_clickhouse_expressions()},
        # redefine
        id                  => 'user_id',
        name                => {dictGetString => [\'users_dict', \'name', {toUInt64 => ['user_id']}]},
        lastname            => {dictGetString => [\'users_dict', \'lastname', {toUInt64 => ['user_id']}]},
        login               => {dictGetString => [\'users_dict', \'login', {toUInt64 => ['user_id']}]},
        client_id           => {dictGetUInt32 => [\'users_dict', \'client_id', {toUInt64 => ['user_id']}]},
        is_tutby            => {dictGetUInt8 => [\'users_dict', \'is_tutby', {toUInt64 => ['user_id']}]},
        is_mobile_mediation => {dictGetUInt8 => [\'users_dict', \'is_mobile_mediation', {toUInt64 => ['user_id']}]},
        is_adfox_partner    => {dictGetUInt8 => [\'users_dict', \'is_adfox_partner', {toUInt64 => ['user_id']}]},
        is_video_blogger    => {dictGetUInt8 => [\'users_dict', \'is_video_blogger', {toUInt64 => ['user_id']}]},
        is_games            => {dictGetUInt8 => [\'users_dict', \'is_games', {toUInt64 => ['user_id']}]},
        is_efir_blogger     => {dictGetUInt8 => [\'users_dict', \'is_efir_blogger', {toUInt64 => ['user_id']}]},
        email               => {dictGetString => [\'users_dict', \'email', {toUInt64 => ['user_id']}]},
        phone               => {dictGetString => [\'users_dict', \'phone', {toUInt64 => ['user_id']}]},
    };
}

sub add_authorization_filter {
    my ($self, $filter) = @_;

    unless ($self->check_rights('statistics_additional_income_always_view')) {
        $filter->and({user_id => $self->get_option('cur_user')->{'id'}});
    }

    return undef;
}

sub fields {
    return {additional_income_partner_wo_nds => {}};
}

TRUE;
