package Application::Model::Statistics::Charging;

use qbit;

use base qw(Application::Model::Statistics::Hierarchy);

sub accessor {'statistics_charging'}

__PACKAGE__->model_accessors(
    partner_db     => 'Application::Model::PartnerDB',
    users          => 'Application::Model::Users',
    statistics_dsp => 'Application::Model::Statistics::Charging::DSP',
);

__PACKAGE__->register_rights(
    [
        {
            name        => 'right_charging_in_statistics',
            description => d_gettext('Rights for charging in statistics'),
            rights      => {statistics_charging_view_field__login => d_gettext('Right to view field "login"'),}
        }
    ]
);

sub children {
    my ($self) = @_;

    return ($self->statistics_dsp);
}

sub entity_fields {
    my ($self) = @_;

    return [
        (
            $self->check_short_rights('view_field__login')
            ? {
                id    => 'login',
                label => gettext('Login'),
                ($self->check_rights('settings_cmd_ucard') ? (type => 'login') : ())
              }
            : ()
        )
    ];
}

# Ф-ция вовращает список полей по которым можо фильтровать СОБЫТИЯ в соответствии с текущим уровнем
sub get_event_fields {
    my ($self) = @_;
    return [];    # события для этого уровня отсутствуют
}

sub sort_priority {260;}

sub support_clickhouse {FALSE}

sub title {gettext('Charging')}

TRUE;
