package Application::Model::Statistics::Fields::Dictionary;

use qbit;

use base qw(Exporter);

our @EXPORT_OK = qw(
  $VAT_TYPES
  $VAT_HASH
  $ACCESSORS_BY_SHORT_PRODUCT
  $PRODUCTS_WITHOUT_POSTFIX_BLOCK
  $PAGE_ACCESSORS_BY_SHORT_PRODUCT
  get_rtb_products
  get_video_products
  );

our $VAT_TYPES = [
    {
        id    => 'w_nds',
        title => d_gettext('with&nbsp;VAT'),
    },
    {
        id      => 'wo_nds',
        title   => d_gettext('w/o&nbsp;VAT'),
        section => 'default',
    },
];

our $VAT_HASH = {map {$_->{'id'} => $_->{'title'}} @$VAT_TYPES};

our $ACCESSORS_BY_SHORT_PRODUCT = {
    adblock_block          => [qw(context_on_site_adblock)],
    direct_context         => [qw(context_on_site_direct internal_context_on_site_direct)],
    direct_search          => [qw(search_on_site_direct internal_search_on_site_direct)],
    dsp                    => [qw(dsp)],
    fullscreen_block       => [qw(video_an_site_fullscreen)],
    inpage_block           => [qw(video_an_site_inpage)],
    instream_block         => [qw(video_an_site_instream)],
    indoor_block           => [qw(indoor_block)],
    outdoor_block          => [qw(outdoor_block)],
    market_api_context     => [qw(context_on_site_market_api)],
    market_api_search      => [qw(search_on_site_market_api)],
    market_context         => [qw(context_on_site_market)],
    market_search          => [qw(search_on_site_market)],
    mcb_context            => [qw(context_on_site_mcb)],
    mcb_search             => [qw(search_on_site_mcb)],
    mobile_mediation_block => [qw(mobile_mediation_block)],
    mobile_rtb_block       => [qw(mobile_app_rtb internal_mobile_app_rtb)],
    premium                => [qw(search_on_site_premium internal_search_on_site_premium)],
    content_block          => [qw(context_on_site_content internal_context_on_site_content)],
    natural_block          => [qw(context_on_site_natural internal_context_on_site_natural)],
    rtb_block => [qw(context_on_site_rtb internal_context_on_site_rtb ssp_context_on_site_rtb ssp_video_an_site_rtb)],
    ssp_context_rtb_block => [qw(ssp_context_on_site_rtb)],
    ssp_mobile_rtb_block  => [qw(ssp_mobile_app_rtb)],
    stripe                => [qw(context_on_site_stripe internal_context_on_site_stripe)],
};

our $PRODUCTS_WITHOUT_POSTFIX_BLOCK = {
    map {my $short_product = $_; $short_product =~ s/_block\z//; ($short_product => $_)}
      keys(%$ACCESSORS_BY_SHORT_PRODUCT)
};

our $PAGE_ACCESSORS_BY_SHORT_PRODUCT = {
    natural        => [qw(context_on_site_campaign internal_context_on_site_campaign)],
    content        => [qw(context_on_site_campaign)],
    direct_context => [
        qw(
          context_on_site_campaign
          internal_context_on_site_campaign
          ssp_context_on_site_campaign
          ssp_video_an_site
          )
    ],
    direct_search  => [qw(search_on_site_campaign internal_search_on_site_campaign)],
    market_context => [qw(context_on_site_campaign ssp_context_on_site_campaign ssp_video_an_site)],
    market_search  => [qw(search_on_site_campaign)],
    mcb_context    => [qw(context_on_site_campaign ssp_context_on_site_campaign ssp_video_an_site)],
    mcb_search     => [qw(search_on_site_campaign)],
    mobile_rtb     => [qw(mobile_app_settings)],
    premium        => [qw(search_on_site_campaign internal_search_on_site_campaign)],
    rtb            => [
        qw(
          context_on_site_campaign
          internal_context_on_site_campaign
          ssp_context_on_site_campaign
          ssp_video_an_site
          )
    ],
    ssp_mobile_rtb => [qw(ssp_mobile_app_settings)],
};

sub get_rtb_products {
    [
        qw(
          adblock_block
          fullscreen_block
          inpage_block
          instream_block
          indoor_block
          outdoor_block
          mobile_mediation_block
          mobile_rtb_block
          rtb_block
          content_block
          natural_block
          ssp_mobile_rtb_block
          )
    ];
}

sub get_video_products {
    [
        qw(
          fullscreen_block
          inpage_block
          instream_block
          indoor_block
          outdoor_block
          )
    ];
}

TRUE;
