package Application::Model::Statistics::Fields::DimensionTypes;

use qbit;

use base qw(Exporter);

our @EXPORT    = qw(@DIMENSION_TYPES %DIMENSION_TYPES);
our @EXPORT_OK = @EXPORT;

our @DIMENSION_TYPES = (
    {
        id        => 'date',
        title     => d_gettext('Period'),
        get       => 'db_select',
        db_fields => ['dt'],
        values    => [
            # These date format strings are for MySQL DATE_FORMAT() function, not standard strftime()
            [day   => d_gettext('Group by day')   => {DATE_FORMAT => ['dt', \'%Y-%m-%d']}],
            [week  => d_gettext('Group by week')  => {DATE_FORMAT => ['dt', \'%x-W%v']}],
            [month => d_gettext('Group by month') => {DATE_FORMAT => ['dt', \'%Y-%m']}],
            [year  => d_gettext('Group by year')  => {DATE_FORMAT => ['dt', \'%Y']}]
        ],
    },
    {
        id            => 'currency_id',
        title         => d_gettext('currency'),
        get           => 'dictionary',
        verbatim      => TRUE,
        db_fields     => ['currency_id'],
        type          => 'dictionary',
        model         => 'currency',
        caption_field => 'code',
    },
    {
        id         => 'tag',
        title      => d_gettext('Tag'),
        get        => 'db',
        only_group => TRUE,
    },
    {
        id         => 'rollback',
        title      => d_gettext('Rollback'),
        get        => 'db',
        type       => 'boolean',
        only_group => TRUE,
    },
    {
        id         => 'finished',
        title      => d_gettext('Finished'),
        get        => 'db',
        type       => 'boolean',
        only_group => TRUE,
    },
    {
        id        => 'dsp_id_name',
        title     => d_gettext('DSP&nbsp;ID'),
        get       => 'dictionary',
        verbatim  => TRUE,
        db_fields => ['dsp_id'],
        type      => 'dictionary',
        ajax      => TRUE,
        sort_as   => 'number',
    },
    {
        id             => 'dsp_caption',
        title          => d_gettext('DSP caption'),
        get            => 'dictionary',
        verbatim       => TRUE,
        db_fields      => ['dsp_id'],
        type           => 'dictionary',
        model          => 'dsp',
        caption_field  => 'short_caption',
        ajax           => TRUE,
        default_prefix => d_gettext('DSP #'),
    },
    {
        id        => 'tag_id',
        title     => d_gettext('Tag&nbsp;ID'),
        get       => 'db',
        verbatim  => TRUE,
        db_fields => ['tag_id'],
        type      => 'number',
        sort_as   => 'number',
    },
    {
        id                => 'tag_caption',
        title             => d_gettext('Tag caption'),
        get               => 'dictionary',
        verbatim          => TRUE,
        model             => ['block_tags'],
        db_fields         => ['tag_id', 'campaign_id'],
        id_field          => 'public_id',
        type              => 'dictionary',
        only_group        => TRUE,
        default_prefix    => d_gettext('Slice #'),
        select_model_only => TRUE,
    },
    {
        id        => 'page_id',
        title     => d_gettext('Page&nbsp;ID'),
        get       => 'dictionary',
        verbatim  => TRUE,
        db_fields => ['campaign_id'],
        type      => 'dictionary',
        ajax      => TRUE,
        sort_as   => 'number',
    },
    {
        id             => 'campaign',
        title          => d_gettext('Site'),
        get            => 'dictionary',
        verbatim       => TRUE,
        model          => 'all_pages',
        db_fields      => ['campaign_id'],
        id_field       => 'page_id',
        type           => 'dictionary',
        caption_field  => 'domain',
        ajax           => TRUE,
        sort_as        => 'text',
        default_prefix => d_gettext('Campaign #'),
    },
    {
        id              => 'is_internal_campaign',
        title           => d_gettext('Internal'),
        get             => 'dictionary',
        model           => 'internal_context_on_site_campaign',
        type            => 'boolean',
        db_fields       => ['campaign_id'],
        id_field        => 'id',
        caption_field   => 'id',
        default_caption => sub {
            return 0;
        },
        only_group => TRUE,
        value      => sub {
            my ($dimension_values, $db_fields, $row) = @_;

            return exists($dimension_values->{$row->{'campaign_id'}}) ? 1 : 0;
        },
    },
    {
        id    => 'order_id',
        title => d_gettext('Order&nbsp;ID'),
        get   => 'db',
        type  => 'text'
    },
    {
        id        => 'video_publisher_id',
        title     => d_gettext('Publisher&nbsp;ID'),
        get       => 'dictionary',
        verbatim  => TRUE,
        db_fields => ['publisher_id'],
        type      => 'dictionary',
        ajax      => TRUE,
        sort_as   => 'text',
    },
    {
        id        => 'video_content_id',
        title     => d_gettext('Content&nbsp;ID'),
        get       => 'dictionary',
        verbatim  => TRUE,
        db_fields => ['content_id'],
        type      => 'dictionary',
        ajax      => TRUE,
        sort_as   => 'text',
    },
    {
        id        => 'video_publisher_name',
        title     => d_gettext('Publisher name'),
        get       => 'dictionary',
        verbatim  => TRUE,
        db_fields => ['publisher_name'],
        type      => 'dictionary',
        ajax      => TRUE,
        sort_as   => 'text',
    },
    {
        id        => 'video_content_name',
        title     => d_gettext('Content name'),
        get       => 'dictionary',
        verbatim  => TRUE,
        db_fields => ['content_name'],
        type      => 'dictionary',
        ajax      => TRUE,
        sort_as   => 'text',
    },
    {
        id        => 'video_clid',
        title     => d_gettext('CLID'),
        get       => 'dictionary',
        verbatim  => TRUE,
        db_fields => ['clid'],
        type      => 'dictionary',
        ajax      => TRUE,
        sort_as   => 'number',
    },
    {
        id            => 'context_campaign_caption',
        title         => d_gettext('Caption campaign'),
        get           => 'dictionary',
        verbatim      => TRUE,
        model         => 'context_on_site_campaign',
        db_fields     => ['campaign_id'],
        id_field      => 'page_id',
        type          => 'dictionary',
        caption_field => 'caption',
        ajax          => TRUE,
        sort_as       => 'text',
    },
    {
        id            => 'context_campaign_caption_by_page_id',
        title         => d_gettext('Caption campaign'),
        get           => 'dictionary',
        verbatim      => TRUE,
        model         => 'context_on_site_campaign',
        db_fields     => ['page_id'],
        id_field      => 'page_id',
        type          => 'dictionary',
        caption_field => 'caption',
        ajax          => TRUE,
        sort_as       => 'text',
    },
    {
        id            => 'search_campaign_caption',
        title         => d_gettext('Caption campaign'),
        get           => 'dictionary',
        verbatim      => TRUE,
        model         => 'search_on_site_campaign',
        db_fields     => ['campaign_id'],
        id_field      => 'page_id',
        type          => 'dictionary',
        caption_field => 'caption',
        ajax          => TRUE,
        sort_as       => 'text',
    },
    {
        id            => 'mobile_caption',
        title         => d_gettext('Caption application'),
        get           => 'dictionary',
        verbatim      => TRUE,
        model         => 'mobile_app_settings',
        db_fields     => ['context_page_id'],
        id_field      => 'context_page_id',
        type          => 'dictionary',
        caption_field => 'caption',
        ajax          => TRUE,
        sort_as       => 'text',
    },
    {
        id            => 'video_caption',
        title         => d_gettext('Caption resource'),
        get           => 'dictionary',
        verbatim      => TRUE,
        model         => 'video_an_site',
        db_fields     => ['page_id'],
        id_field      => 'id',
        type          => 'dictionary',
        caption_field => 'caption',
        ajax          => TRUE,
        sort_as       => 'text',
    },
    {
        id            => 'an_campaign_caption',
        title         => d_gettext('Caption campaign'),
        get           => 'dictionary',
        verbatim      => TRUE,
        model         => ['context_on_site_campaign', 'search_on_site_campaign'],
        db_fields     => ['campaign_id'],
        id_field      => 'page_id',
        type          => 'dictionary',
        caption_field => 'caption',
        ajax          => TRUE,
        sort_as       => 'text',
    },
    {
        id            => 'internal_mobile_caption',
        title         => d_gettext('Caption application'),
        get           => 'dictionary',
        verbatim      => TRUE,
        model         => 'internal_mobile_app',
        db_fields     => ['application_id'],
        id_field      => 'id',
        type          => 'dictionary',
        caption_field => 'caption',
        ajax          => TRUE,
        sort_as       => 'text',
    },
    {
        id         => 'public_id',
        title      => d_gettext('Block&nbsp;ID'),
        get        => 'db',
        type       => 'public_id',
        only_group => TRUE,
    },
    {
        id        => 'adfox_block',
        title     => d_gettext('ADFOX block'),
        get       => 'db',
        db_fields => ['adfox_block'],
        type      => 'boolean',
    },
    {
        id            => 'mobile_block_type_label',
        title         => d_gettext('Block type'),
        get           => 'dictionary',
        verbatim      => TRUE,
        model         => 'mobile_app_rtb',
        id_field      => 'block_type',
        caption_field => 'block_type_label',
        db_fields     => ['block_type'],
        type          => 'dictionary',
        sort_as       => 'text',
        only_group    => TRUE,
    },
    {
        id            => 'internal_mobile_block_type_label',
        title         => d_gettext('Block type'),
        get           => 'dictionary',
        verbatim      => TRUE,
        model         => 'internal_mobile_app_rtb',
        id_field      => 'block_type',
        caption_field => 'block_type_label',
        db_fields     => ['block_type'],
        type          => 'dictionary',
        sort_as       => 'text',
        only_group    => TRUE,
    },
    {
        id              => 'categories',
        title           => d_gettext('Categories'),
        get             => 'dictionary',
        verbatim        => TRUE,
        db_fields       => ['category_id'],
        type            => 'dictionary',
        model           => 'video_an_site_categories',
        caption_field   => 'name',
        ajax            => TRUE,
        default_caption => sub {
            return $_[1]->{$_[0]->[0]};
        },
    },
    {
        id             => 'monetizer_caption',
        title          => d_gettext('Monetizer'),
        get            => 'dictionary',
        verbatim       => TRUE,
        db_fields      => ['monetizer_id'],
        type           => 'dictionary',
        model          => 'monetizers',
        caption_field  => 'caption',
        ajax           => TRUE,
        default_prefix => d_gettext('Monetizer #'),
    },
    {
        id         => 'geo_name',
        title      => d_gettext('Geography'),
        get        => 'dictionary',
        type       => 'dictionary',
        verbatim   => TRUE,
        db_fields  => ['geo_id'],
        sort_as    => 'text',
        ajax       => TRUE,
        only_group => TRUE,
    },
);

our %DIMENSION_TYPES = map {$_->{'id'} => $_} @DIMENSION_TYPES;

TRUE;
