package Application::Model::Statistics::Fields::Hints;

use qbit;

use base qw(Exporter);

our @EXPORT = qw($HINTS);

our $HINTS = {
    instream_partner                 => d_gettext('instream_partner__hint'),
    inpage_partner                   => d_gettext('inpage_partner__hint'),
    fullscreen_partner               => d_gettext('fullscreen_partner__hint'),
    indoor_partner                   => d_gettext('indoor_partner__hint'),
    outdoor_partner                  => d_gettext('outdoor_partner__hint'),
    instream_bad_win_partner_price   => d_gettext('instream_bad_win_partner_price__hint'),
    inpage_bad_win_partner_price     => d_gettext('inpage_bad_win_partner_price__hint'),
    fullscreen_bad_win_partner_price => d_gettext('fullscreen_bad_win_partner_price__hint'),
    indoor_bad_win_partner_price     => d_gettext('indoor_bad_win_partner_price__hint'),
    outdoor_bad_win_partner_price    => d_gettext('outdoor_bad_win_partner_price__hint'),
    content_partner => d_gettext('Remuneration of the partner for ads in Content-blocks on thematic campaigns'),
    content_bad_win_partner_price => d_gettext('content_bad_win_partner_price__hint'),
    natural_partner => d_gettext('Remuneration of the partner for ads in Natural-blocks on thematic campaigns'),
    natural_bad_win_partner_price => d_gettext('natural_bad_win_partner_price__hint'),
    rtb_partner               => d_gettext('Remuneration of the partner for ads in RTB-blocks on thematic campaigns'),
    rtb_bad_win_partner_price => d_gettext('rtb_bad_win_partner_price__hint'),
    mobile_rtb_partner        => d_gettext('Amount of money earned by partner by RTB Mobile.'),
    mobile_rtb_bad_win_partner_price => d_gettext('mobile_rtb_bad_win_partner_price__hint'),
    ssp_mobile_rtb_partner           => d_gettext('ssp_mobile_rtb_partner__hint'),
    ssp_context_rtb_partner          => d_gettext('ssp_context_rtb_partner__hint'),
    adblock_partner                  => d_gettext('adblock_partner__hint'),
    premium_partner                  => d_gettext('premium_partner__hint'),
    direct_context_partner           => d_gettext('direct_context_partner__hint'),
    direct_search_partner            => d_gettext('direct_search_partner__hint'),
    mcb_context_partner              => d_gettext('mcb_context_partner__hint'),
    mcb_search_partner               => d_gettext('mcb_search_partner__hint'),
    market_context_partner           => d_gettext('market_context_partner__hint'),
    market_api_context_partner       => d_gettext('market_api_context_partner__hint'),
    market_search_partner            => d_gettext('market_search_partner__hint'),
    market_api_search_partner        => d_gettext('market_api_search_partner__hint'),
    stripe_partner                   => d_gettext('The total remuneration of the partner for Stripes'),
    partner                          => d_gettext('partner__hint'),
    bad_win_partner_price            => d_gettext('bad_win_partner_price__hint'),
    rs_all                           => d_gettext('Complete turnover of money by revenue share.'),
    instream_all                     => d_gettext('instream_all__hint'),
    inpage_all                       => d_gettext('inpage_all__hint'),
    fullscreen_all                   => d_gettext('fullscreen_all__hint'),
    indoor_all                       => d_gettext('indoor_all__hint'),
    outdoor_all                      => d_gettext('outdoor_all__hint'),
    instream_bad_win_price           => d_gettext('instream_bad_win_price__hint'),
    inpage_bad_win_price             => d_gettext('inpage_bad_win_price__hint'),
    fullscreen_bad_win_price         => d_gettext('fullscreen_bad_win_price__hint'),
    indoor_bad_win_price             => d_gettext('indoor_bad_win_price__hint'),
    outdoor_bad_win_price            => d_gettext('outdoor_bad_win_price__hint'),
    content_all                      => d_gettext('Overall turnover decommissioned advertisers'),
    content_bad_win_price            => d_gettext('content_bad_win_price__hint'),
    natural_all                      => d_gettext('Overall turnover decommissioned advertisers'),
    natural_bad_win_price            => d_gettext('natural_bad_win_price__hint'),
    rtb_all                          => d_gettext('Overall turnover decommissioned advertisers'),
    rtb_bad_win_price                => d_gettext('rtb_bad_win_price__hint'),
    mobile_rtb_all                   => d_gettext('Overall turnover decommissioned advertisers'),
    mobile_rtb_bad_win_price         => d_gettext('mobile_rtb_bad_win_price__hint'),
    ssp_mobile_rtb_all               => d_gettext('ssp_mobile_rtb_all__hint'),
    ssp_context_rtb_all              => d_gettext('ssp_context_rtb_all__hint'),
    adblock_all                      => d_gettext('adblock_all__hint'),
    premium_all                      => d_gettext('Complete turnover of money, advertisers charge.'),
    direct_context_all               => d_gettext('direct_context_all__hint'),
    direct_search_all                => d_gettext('direct_search_all__hint'),
    mcb_context_all                  => d_gettext('mcb_context_all__hint'),
    mcb_search_all                   => d_gettext('mcb_search_all__hint'),
    market_context_all               => d_gettext('market_context_all__hint'),
    market_api_context_all           => d_gettext('market_api_context_all__hint'),
    market_search_all                => d_gettext('market_search_all__hint'),
    market_api_search_all            => d_gettext('market_api_search_all__hint'),
    stripe_all                       => d_gettext('Complete turnover of money, advertisers charge.'),
    all                              => d_gettext('all__hint'),
    dsp_charging                     => d_gettext('Charging partner in accordance with the service rendered'),
    all_real_price                   => d_gettext('The sum of all bids partner per day'),
    charging                         => d_gettext('Charging partner in accordance with the service rendered'),
    bk_price                         => d_gettext('Complete turnover of money, advertisers charge.'),
    bk_partner_price                 => d_gettext('Amount of money earned by partner by Video.'),
    bad_win_price                    => d_gettext('bad_win_price__hint'),
    instream_block_view              => d_gettext('instream_block_view__hint'),
    an_content_cover_hits            => d_gettext(
'Treatment Content host to Banner system guidelines for the auction; if on page 3 blocks Content, the auction will be 3'
    ),
    an_natural_cover_hits => d_gettext(
'Treatment Natural host to Banner system guidelines for the auction; if on page 3 blocks Natural, the auction will be 3'
    ),
    an_rtb_cover_hits => d_gettext(
        'Treatment RTB host to Banner system guidelines for the auction; if on page 3 blocks RTB, the auction will be 3'
    ),
    an_mobile_rtb_cover_hits => d_gettext(
'Treatment RTB Mobile host to Banner system guidelines for the auction; if on page 3 blocks RTB Mobile, the auction will be 3'
    ),
    an_ssp_mobile_rtb_cover_hits => d_gettext(
'Treatment SSP RTB Mobile host to Banner system guidelines for the auction; if on page 3 blocks SSP RTB Mobile, the auction will be 3'
    ),
    dsp_bids                  => d_gettext('The number of partner won auctions.'),
    an_content_cover_senthits => d_gettext(
"Answers Direct's Banner system Content host at least one ad; if on page 3 blocks Content, then auctions is likely to be 3"
    ),
    an_natural_cover_senthits => d_gettext(
"Answers Direct's Banner system Natural host at least one ad; if on page 3 blocks Natural, then auctions is likely to be 3"
    ),
    an_rtb_cover_senthits => d_gettext(
"Answers Direct's Banner system RTB host at least one ad; if on page 3 blocks RTB, then auctions is likely to be 3"
    ),
    an_mobile_rtb_cover_senthits => d_gettext(
"Answers Direct's Banner system RTB Mobile host at least one ad; if on page 3 blocks RTB Mobile, then auctions is likely to be 3"
    ),
    an_ssp_mobile_rtb_cover_senthits => d_gettext(
"Answers Direct's Banner system SSP RTB Mobile host at least one ad; if on page 3 blocks SSP RTB Mobile, then auctions is likely to be 3"
    ),
    an_cover_hits => d_gettext(
"Requests received the banner system from the partner's page; if a page a few blocks of Direct, Premium, Market or MCB, the request will be 1"
    ),
    (
        map {$_ => d_gettext('The number of times an page is displayed')}
          qw(direct_search_hits mcb_search_hits market_search_hits premium_hits)
    ),
    an_cover_senthits => d_gettext(
"Answers banner system on partner's pages; if a page a few blocks of Direct, Premium, Market or MCB, the answer is 1"
    ),
    instream_block_open_player        => d_gettext('instream_block_open_player__hint'),
    instream_block_preroll_shows      => d_gettext('instream_block_preroll_shows__hint'),
    instream_block_preroll_hits       => d_gettext('instream_block_preroll_hits__hint'),
    instream_block_preroll_all_hits   => d_gettext('instream_block_preroll_all_hits__hint'),
    instream_block_postroll_shows     => d_gettext('instream_block_postroll_shows__hint'),
    instream_block_postroll_hits      => d_gettext('instream_block_postroll_hits__hint'),
    instream_block_postroll_all_hits  => d_gettext('instream_block_postroll_all_hits__hint'),
    instream_block_midroll_shows      => d_gettext('instream_block_midroll_shows__hint'),
    instream_block_midroll_hits       => d_gettext('instream_block_midroll_hits__hint'),
    instream_block_midroll_all_hits   => d_gettext('instream_block_midroll_all_hits__hint'),
    instream_block_pauseroll_shows    => d_gettext('instream_block_pauseroll_shows__hint'),
    instream_block_pauseroll_hits     => d_gettext('instream_block_pauseroll_hits__hint'),
    instream_block_pauseroll_all_hits => d_gettext('instream_block_pauseroll_all_hits__hint'),
    premium_page_ad_shows             => d_gettext(
"Pages where was seen by at least one Premium's block; if a page a few Premium blocks: one in the visible and one downstairs, then the answer is 1"
    ),
    an_cover_direct_hits => d_gettext(
"Pages where was seen by at least one Direct's block; not yet cleared of fraud; if a page a few Direct's blocks: one in the visible and one downstairs, then the answer is 1"
    ),
    an_cover_market_hits => d_gettext(
"Pages where was seen by at least one Market's block; if a page a few Market's blocks: one in the visible and one downstairs, then the answer is 1"
    ),
    an_cover_mcb_hits => d_gettext(
'Pages where was seen by at least one MCB block; if a page a few MCB blocks: one in the visible and one downstairs, then the answer is 1'
    ),
    premium_ads => d_gettext(
        "Approximate number of Premium's ads per partner's page; Calculated as the ratio of shows to the number of hits"
    ),
    (
        map {
            $_ => d_gettext(
"Approximate number of Direct's ads per partner's page; Calculated as the ratio of shows to the number of hits"
              )
          } qw(direct_context_ads direct_search_ads)
    ),
    an_fraud_shows  => d_gettext('Invalid (unfair and erroneous) shows not passed automatic filtering techniques.'),
    an_fraud_clicks => d_gettext(
'Invalid (unfair and erroneous) clicks are not passed automatic filtering techniques. These clicks are not included in the figures and the means for them not debited from the publisher.'
    ),
    an_content_cover_direct_hits =>
      d_gettext('Direct ad shows in Content-blocks on thematic campaigns based on check visibility'),
    an_natural_cover_direct_hits =>
      d_gettext('Direct ad shows in Natural-blocks on thematic campaigns based on check visibility'),
    an_rtb_cover_direct_hits =>
      d_gettext('Direct ad shows in RTB-blocks on thematic campaigns based on check visibility'),
    an_mobile_rtb_cover_direct_hits => d_gettext(
"Shows Direct's blocks that have been seen by visitors; For example, in the first screen two blocks: in the first block won media, in the second block won Direct + 1 block in footer  out of sight — 1 direct show"
    ),
    an_ssp_mobile_rtb_cover_direct_hits => d_gettext(
"Shows Direct's blocks that have been seen by visitors; For example, in the first screen two blocks: in the first block won media, in the second block won Direct + 1 block in footer  out of sight — 1 direct show"
    ),
    (
        map {
            $_ => d_gettext(
"Pages where was seen by at least one Direct's block; if a page a few Direct blocks: one in the visible and one downstairs, then the answer is 1"
              )
          } qw(direct_context_page_ad_shows direct_search_page_ad_shows)
    ),
    direct_ad_visibility => d_gettext('direct_ad_visibility__hint'),
    direct_ad_reach      => d_gettext(
'The ratio of responses banner system Direct at least one advertisement to requests Direct block on the page. (sent hits / hits *100)'
    ),
    direct_ad_coverage => d_gettext(
'The ratio of pages hits with recorded shows block Yandex.Direct to requests block Direct on the page. (directed hits/ hits *100)'
    ),
    instream_block_hits                       => d_gettext('instream_block_hits__hint'),
    inpage_block_hits                         => d_gettext('inpage_block_hits__hint'),
    fullscreen_block_hits                     => d_gettext('fullscreen_block_hits__hint'),
    indoor_block_hits                         => d_gettext('indoor_block_hits__hint'),
    outdoor_block_hits                        => d_gettext('outdoor_block_hits__hint'),
    instream_block_direct_clicks              => d_gettext('instream_block_direct_clicks__hint'),
    inpage_block_direct_clicks                => d_gettext('inpage_block_direct_clicks__hint'),
    fullscreen_block_direct_clicks            => d_gettext('fullscreen_block_direct_clicks__hint'),
    indoor_block_direct_clicks                => d_gettext('indoor_block_direct_clicks__hint'),
    outdoor_block_direct_clicks               => d_gettext('outdoor_block_direct_clicks__hint'),
    video_bk_hits                             => d_gettext('Ad requests from the code to call the host RTB.'),
    content_block_hits                        => d_gettext('content_block_hits__hint'),
    content_block_bad_win_hits                => d_gettext('content_block_bad_win_hits__hint'),
    natural_block_hits                        => d_gettext('natural_block_hits__hint'),
    natural_block_bad_win_hits                => d_gettext('natural_block_bad_win_hits__hint'),
    inpage_block_bad_win_hits                 => d_gettext('inpage_block_bad_win_hits__hint'),
    instream_block_bad_win_hits               => d_gettext('instream_block_bad_win_hits__hint'),
    fullscreen_block_bad_win_hits             => d_gettext('fullscreen_block_bad_win_hits__hint'),
    indoor_block_bad_win_hits                 => d_gettext('indoor_block_bad_win_hits__hint'),
    outdoor_block_bad_win_hits                => d_gettext('outdoor_block_bad_win_hits__hint'),
    rtb_block_hits                            => d_gettext('rtb_block_hits__hint'),
    rtb_block_bad_win_hits                    => d_gettext('rtb_block_bad_win_hits__hint'),
    mobile_mediation_block_hits               => d_gettext('mobile_mediation_block_hits__hint'),
    mobile_mediation_block_impressions        => d_gettext('mobile_mediation_block_impressions__hint'),
    mobile_mediation_block_visibility         => d_gettext('mobile_mediation_block_visibility__hint'),
    mobile_mediation_block_calculated_revenue => d_gettext('mobile_mediation_block_calculated_revenue__hint'),
    mobile_mediation_block_calculated_revenue_original =>
      d_gettext('mobile_mediation_block_calculated_revenue_original__hint'),
    mobile_rtb_block_hits         => d_gettext('mobile_rtb_block_hits__hint'),
    mobile_rtb_block_bad_win_hits => d_gettext('mobile_rtb_block_bad_win_hits__hint'),
    direct_context_hits           => d_gettext('direct_context_hits__hint'),
    mcb_context_hits              => d_gettext('mcb_context_hits__hint'),
    market_context_hits           => d_gettext('market_context_hits__hint'),
    stripe_hits                   => d_gettext('stripe_hits__hint'),
    ssp_mobile_rtb_block_hits     => d_gettext('ssp_mobile_rtb_block_hits__hint'),
    adblock_block_hits            => d_gettext('adblock_block_hits__hint'),
    instream_block_bad_shows      => d_gettext('instream_block_bad_shows__hint'),
    inpage_block_bad_shows        => d_gettext('inpage_block_bad_shows__hint'),
    fullscreen_block_bad_shows    => d_gettext('fullscreen_block_bad_shows__hint'),
    indoor_block_bad_shows        => d_gettext('indoor_block_bad_shows__hint'),
    outdoor_block_bad_shows       => d_gettext('outdoor_block_bad_shows__hint'),
    instream_block_shows          => d_gettext('instream_block_shows__hint'),
    inpage_block_shows            => d_gettext('inpage_block_shows__hint'),
    fullscreen_block_shows        => d_gettext('fullscreen_block_shows__hint'),
    indoor_block_shows            => d_gettext('indoor_block_shows__hint'),
    outdoor_block_shows           => d_gettext('outdoor_block_shows__hint'),
    instream_block_direct_shows   => d_gettext('instream_block_direct_shows__hint'),
    inpage_block_direct_shows     => d_gettext('inpage_block_direct_shows__hint'),
    fullscreen_block_direct_shows => d_gettext('fullscreen_block_direct_shows__hint'),
    indoor_block_direct_shows     => d_gettext('indoor_block_direct_shows__hint'),
    outdoor_block_direct_shows    => d_gettext('outdoor_block_direct_shows__hint'),
    video_bk_shows             => d_gettext('The number of times an ad is displayed, whether it is clicked on or not.'),
    content_block_shows        => d_gettext('Number of shows Content-blocks on thematic campaigns'),
    content_block_bad_shows    => d_gettext('content_block_bad_shows__hint'),
    content_block_direct_shows => d_gettext('content_block_direct_shows__hint'),
    natural_block_shows        => d_gettext('Number of shows Natural-blocks on thematic campaigns'),
    natural_block_bad_shows    => d_gettext('natural_block_bad_shows__hint'),
    natural_block_direct_shows => d_gettext('natural_block_direct_shows__hint'),
    rtb_block_shows            => d_gettext('Number of shows RTB-blocks on thematic campaigns'),
    rtb_block_bad_shows        => d_gettext('rtb_block_bad_shows__hint'),
    rtb_block_direct_shows     => d_gettext('rtb_block_direct_shows__hint'),
    mobile_rtb_block_shows     => d_gettext('The number of mobile RTB-blocks shows in applications'),
    mobile_rtb_block_bad_shows => d_gettext('mobile_rtb_block_bad_shows__hint'),
    mobile_rtb_block_direct_shows => d_gettext('mobile_rtb_block_direct_shows__hint'),
    premium_shows                 => d_gettext('The number of ad shows in Premium blocks on search campaigns'),
    direct_context_shows          => d_gettext('direct_context_shows__hint'),
    direct_search_shows           => d_gettext('direct_search_shows__hint'),
    mcb_context_shows             => d_gettext('mcb_context_shows__hint'),
    mcb_search_shows              => d_gettext('mcb_search_shows__hint'),
    market_context_shows          => d_gettext('market_context_shows__hint'),
    market_api_context_shows      => d_gettext('market_api_context_shows__hint'),
    market_search_shows           => d_gettext('market_search_shows__hint'),
    market_api_search_shows       => d_gettext('market_api_search_shows__hint'),
    stripe_shows                  => d_gettext('The number of Stripe shows'),
    ssp_mobile_rtb_block_shows    => d_gettext('ssp_mobile_rtb_block_shows__hint'),
    adblock_block_shows           => d_gettext('adblock_block_shows__hint'),
    dsp_shows =>
      d_gettext('In the advertising network the actual ad views are counted taking into account visibility checks.'),
    content_block_direct_clicks    => d_gettext('content_block_direct_clicks__hint'),
    natural_block_direct_clicks    => d_gettext('natural_block_direct_clicks__hint'),
    rtb_block_direct_clicks        => d_gettext('rtb_block_direct_clicks__hint'),
    mobile_rtb_block_direct_clicks => d_gettext('mobile_rtb_block_direct_clicks__hint'),
    premium_clicks                 => d_gettext('The number of clicks by ad in Premium blocks on search campaigns'),
    direct_context_clicks          => d_gettext('direct_context_clicks__hint'),
    direct_search_clicks           => d_gettext('direct_search_clicks__hint'),
    mcb_context_clicks             => d_gettext('mcb_context_clicks__hint'),
    mcb_search_clicks              => d_gettext('mcb_search_clicks__hint'),
    market_context_clicks          => d_gettext('market_context_clicks__hint'),
    market_api_context_clicks      => d_gettext('market_api_context_clicks__hint'),
    market_search_clicks           => d_gettext('market_search_clicks__hint'),
    market_api_search_clicks       => d_gettext('market_api_search_clicks__hint'),
    stripe_clicks                  => d_gettext('The number of clicks by Stripe'),
    instream_block_hits_own_adv    => d_gettext('instream_block_hits_own_adv__hint'),
    inpage_block_hits_own_adv      => d_gettext('inpage_block_hits_own_adv__hint'),
    fullscreen_block_hits_own_adv  => d_gettext('fullscreen_block_hits_own_adv__hint'),
    indoor_block_hits_own_adv      => d_gettext('indoor_block_hits_own_adv__hint'),
    outdoor_block_hits_own_adv     => d_gettext('outdoor_block_hits_own_adv__hint'),
    video_bk_hits_own_adv          => d_gettext('Calls its advertising code specified in the settings block.'),
    content_block_hits_own_adv =>
      d_gettext('The number of requests of code its advertising in Content-blocks on thematic campaigns'),
    content_block_bad_win_hits_own_adv => d_gettext('content_block_bad_win_hits_own_adv__hint'),
    natural_block_hits_own_adv =>
      d_gettext('The number of requests of code its advertising in Natural-blocks on thematic campaigns'),
    natural_block_bad_win_hits_own_adv    => d_gettext('natural_block_bad_win_hits_own_adv__hint'),
    inpage_block_bad_win_hits_own_adv     => d_gettext('inpage_block_bad_win_hits_own_adv__hint'),
    instream_block_bad_win_hits_own_adv   => d_gettext('instream_block_bad_win_hits_own_adv__hint'),
    fullscreen_block_bad_win_hits_own_adv => d_gettext('fullscreen_block_bad_win_hits_own_adv__hint'),
    indoor_block_bad_win_hits_own_adv     => d_gettext('indoor_block_bad_win_hits_own_adv__hint'),
    outdoor_block_bad_win_hits_own_adv    => d_gettext('outdoor_block_bad_win_hits_own_adv__hint'),
    rtb_block_hits_own_adv =>
      d_gettext('The number of requests of code its advertising in RTB-blocks on thematic campaigns'),
    rtb_block_bad_win_hits_own_adv => d_gettext('rtb_block_bad_win_hits_own_adv__hint'),
    mobile_rtb_block_hits_own_adv =>
      d_gettext('The number of code requests its advertising in mobile RTB-blocks in applications'),
    mobile_rtb_block_bad_win_hits_own_adv => d_gettext('mobile_rtb_block_bad_win_hits_own_adv__hint'),
    ssp_mobile_rtb_block_hits_own_adv     => d_gettext('ssp_mobile_rtb_block_hits_own_adv__hint'),
    adblock_block_hits_own_adv            => d_gettext('adblock_block_hits_own_adv__hint'),
    instream_block_shows_own_adv          => d_gettext('instream_block_shows_own_adv__hint'),
    inpage_block_shows_own_adv            => d_gettext('inpage_block_shows_own_adv__hint'),
    fullscreen_block_shows_own_adv        => d_gettext('fullscreen_block_shows_own_adv__hint'),
    indoor_block_shows_own_adv            => d_gettext('indoor_block_shows_own_adv__hint'),
    outdoor_block_shows_own_adv           => d_gettext('outdoor_block_shows_own_adv__hint'),
    instream_block_bad_shows_own_adv      => d_gettext('instream_block_bad_shows_own_adv__hint'),
    inpage_block_bad_shows_own_adv        => d_gettext('inpage_block_bad_shows_own_adv__hint'),
    fullscreen_block_bad_shows_own_adv    => d_gettext('fullscreen_block_bad_shows_own_adv__hint'),
    indoor_block_bad_shows_own_adv        => d_gettext('indoor_block_bad_shows_own_adv__hint'),
    outdoor_block_bad_shows_own_adv       => d_gettext('outdoor_block_bad_shows_own_adv__hint'),
    video_bk_shows_own_adv                => d_gettext('Showing their advertising on the page the user.'),
    content_block_shows_own_adv =>
      d_gettext('The number of shows its advertising in Content-blocks on thematic campaigns'),
    content_block_bad_shows_own_adv => d_gettext('content_block_bad_shows_own_adv__hint'),
    natural_block_shows_own_adv =>
      d_gettext('The number of shows its advertising in Natural-blocks on thematic campaigns'),
    natural_block_bad_shows_own_adv => d_gettext('natural_block_bad_shows_own_adv__hint'),
    rtb_block_shows_own_adv     => d_gettext('The number of shows its advertising in RTB-blocks on thematic campaigns'),
    rtb_block_bad_shows_own_adv => d_gettext('rtb_block_bad_shows_own_adv__hint'),
    mobile_rtb_block_shows_own_adv =>
      d_gettext('The number of shows its advertising in mobile RTB-blocks in applications'),
    mobile_rtb_block_bad_shows_own_adv => d_gettext('mobile_rtb_block_bad_shows_own_adv__hint'),
    adblock_block_shows_own_adv        => d_gettext('adblock_block_shows_own_adv__hint'),
    instream_block_hits_unsold         => d_gettext('instream_block_hits_unsold__hint'),
    inpage_block_hits_unsold           => d_gettext('inpage_block_hits_unsold__hint'),
    fullscreen_block_hits_unsold       => d_gettext('fullscreen_block_hits_unsold__hint'),
    indoor_block_hits_unsold           => d_gettext('indoor_block_hits_unsold__hint'),
    outdoor_block_hits_unsold          => d_gettext('outdoor_block_hits_unsold__hint'),
    video_bk_hits_unsold               => d_gettext('Request advertising, which could not find an advertiser'),
    content_block_hits_unsold          => d_gettext(
'The number of requests that could not find ads (excluding its advertising) for Content-blocks on thematic campaigns'
    ),
    content_block_bad_win_hits_unsold => d_gettext('content_block_bad_win_hits_unsold__hint'),
    natural_block_hits_unsold         => d_gettext(
'The number of requests that could not find ads (excluding its advertising) for Natural-blocks on thematic campaigns'
    ),
    natural_block_bad_win_hits_unsold    => d_gettext('natural_block_bad_win_hits_unsold__hint'),
    inpage_block_bad_win_hits_unsold     => d_gettext('inpage_block_bad_win_hits_unsold__hint'),
    instream_block_bad_win_hits_unsold   => d_gettext('instream_block_bad_win_hits_unsold__hint'),
    fullscreen_block_bad_win_hits_unsold => d_gettext('fullscreen_block_bad_win_hits_unsold__hint'),
    indoor_block_bad_win_hits_unsold     => d_gettext('indoor_block_bad_win_hits_unsold__hint'),
    outdoor_block_bad_win_hits_unsold    => d_gettext('outdoor_block_bad_win_hits_unsold__hint'),
    rtb_block_hits_unsold                => d_gettext(
'The number of requests that could not find ads (excluding its advertising) for RTB-blocks on thematic campaigns'
    ),
    rtb_block_bad_win_hits_unsold => d_gettext('rtb_block_bad_win_hits_unsold__hint'),
    mobile_rtb_block_hits_unsold  => d_gettext(
'The number of requests that could not find ads (excluding its advertising), for Mobile RTB-blocks in applications'
    ),
    mobile_rtb_block_bad_win_hits_unsold => d_gettext('mobile_rtb_block_bad_win_hits_unsold__hint'),
    ssp_mobile_rtb_block_hits_unsold     => d_gettext('ssp_mobile_rtb_block_hits_unsold__hint'),
    adblock_block_hits_unsold            => d_gettext('adblock_block_hits_unsold__hint'),
    video_an_site_all_hits               => d_gettext('video_an_site_all_hits__hint'),
    video_an_site_all_shows              => d_gettext('video_an_site_all_shows__hint'),
    video_an_site_all_hits_own_adv       => d_gettext('video_an_site_all_hits_own_adv__hint'),
    video_an_site_all_shows_own_adv      => d_gettext('video_an_site_all_shows_own_adv__hint'),
    video_an_site_all_hits_unsold        => d_gettext('video_an_site_all_hits_unsold__hint'),
    indoor_all_hits                      => d_gettext('indoor_all_hits__hint'),
    indoor_all_shows                     => d_gettext('indoor_all_shows__hint'),
    indoor_all_hits_own_adv              => d_gettext('indoor_all_hits_own_adv__hint'),
    indoor_all_shows_own_adv             => d_gettext('indoor_all_shows_own_adv__hint'),
    indoor_all_hits_unsold               => d_gettext('indoor_all_hits_unsold__hint'),
    outdoor_all_hits                     => d_gettext('outdoor_all_hits__hint'),
    outdoor_all_shows                    => d_gettext('outdoor_all_shows__hint'),
    outdoor_all_hits_own_adv             => d_gettext('outdoor_all_hits_own_adv__hint'),
    outdoor_all_shows_own_adv            => d_gettext('outdoor_all_shows_own_adv__hint'),
    outdoor_all_hits_unsold              => d_gettext('outdoor_all_hits_unsold__hint'),
    instream_block_all_hits              => d_gettext('instream_block_all_hits__hint'),
    inpage_block_all_hits                => d_gettext('inpage_block_all_hits__hint'),
    fullscreen_block_all_hits            => d_gettext('fullscreen_block_all_hits__hint'),
    indoor_block_all_hits                => d_gettext('indoor_block_all_hits__hint'),
    outdoor_block_all_hits               => d_gettext('outdoor_block_all_hits__hint'),
    video_an_site_sum_all_hits           => d_gettext('video_an_site_sum_all_hits__hint'),
    indoor_sum_all_hits                  => d_gettext('indoor_sum_all_hits__hint'),
    outdoor_sum_all_hits                 => d_gettext('outdoor_sum_all_hits__hint'),
    video_bk_all_hits                    => d_gettext('Request advertising, which could not find an advertiser'),
    content_block_all_hits               => d_gettext('content_block_all_hits__hint'),
    natural_block_all_hits               => d_gettext('natural_block_all_hits__hint'),
    rtb_block_all_hits                   => d_gettext('rtb_block_all_hits__hint'),
    mobile_rtb_block_all_hits            => d_gettext('mobile_rtb_block_all_hits__hint'),
    ssp_mobile_rtb_block_all_hits        => d_gettext('ssp_mobile_rtb_block_all_hits__hint'),
    adblock_block_all_hits               => d_gettext('adblock_block_all_hits__hint'),
    all_hits => d_gettext("Answers Partner's DSP RTB host during the auction. The answer could not win."),
    content_block_bad_win_hits_percent    => d_gettext('content_block_bad_win_hits_percent__hint'),
    natural_block_bad_win_hits_percent    => d_gettext('natural_block_bad_win_hits_percent__hint'),
    inpage_block_bad_win_hits_percent     => d_gettext('inpage_block_bad_win_hits_percent__hint'),
    instream_block_bad_win_hits_percent   => d_gettext('instream_block_bad_win_hits_percent__hint'),
    fullscreen_block_bad_win_hits_percent => d_gettext('fullscreen_block_bad_win_hits_percent__hint'),
    indoor_block_bad_win_hits_percent     => d_gettext('indoor_block_bad_win_hits_percent__hint'),
    outdoor_block_bad_win_hits_percent    => d_gettext('outdoor_block_bad_win_hits_percent__hint'),
    rtb_block_bad_win_hits_percent        => d_gettext('rtb_block_bad_win_hits_percent__hint'),
    mobile_rtb_block_bad_win_hits_percent => d_gettext('mobile_rtb_block_bad_win_hits_percent__hint'),
    content_block_bad_shows_percent       => d_gettext('content_block_bad_shows_percent__hint'),
    natural_block_bad_shows_percent       => d_gettext('natural_block_bad_shows_percent__hint'),
    inpage_block_bad_shows_percent        => d_gettext('inpage_block_bad_shows_percent__hint'),
    instream_block_bad_shows_percent      => d_gettext('instream_block_bad_shows_percent__hint'),
    fullscreen_block_bad_shows_percent    => d_gettext('fulscreen_block_bad_shows_percent__hint'),
    indoor_block_bad_shows_percent        => d_gettext('fulscreen_block_bad_shows_percent__hint'),
    outdoor_block_bad_shows_percent       => d_gettext('fulscreen_block_bad_shows_percent__hint'),
    rtb_block_bad_shows_percent           => d_gettext('rtb_block_bad_shows_percent__hint'),
    mobile_rtb_block_bad_shows_percent    => d_gettext('mobile_rtb_block_bad_shows_percent__hint'),
    instream_block_winrate                => d_gettext('instream_block_winrate__hint'),
    inpage_block_winrate                  => d_gettext('inpage_block_winrate__hint'),
    fullscreen_block_winrate              => d_gettext('fullscreen_block_winrate__hint'),
    indoor_block_winrate                  => d_gettext('indoor_block_winrate__hint'),
    outdoor_block_winrate                 => d_gettext('outdoor_block_winrate__hint'),
    content_block_winrate                 => d_gettext(
'The ratio of the number of requests that have successfully picked up ads to the total number of requests for Content-blocks on the thematic campaigns, in percentages'
    ),
    natural_block_winrate => d_gettext(
'The ratio of the number of requests that have successfully picked up ads to the total number of requests for Natural-blocks on the thematic campaigns, in percentages'
    ),
    rtb_block_winrate => d_gettext(
'The ratio of the number of requests that have successfully picked up ads to the total number of requests for RTB-blocks on the thematic campaigns, in percentages'
    ),
    mobile_rtb_block_winrate => d_gettext(
'The ratio of the number of requests that have successfully picked up ads to the total number of requests for mobile RTB-blocks in applications, in percentages'
    ),
    ssp_mobile_rtb_block_winrate => d_gettext('ssp_mobile_rtb_block_winrate__hint'),
    adblock_block_winrate        => d_gettext('adblock_block_winrate__hint'),
    instream_block_visibility    => d_gettext('instream_block_visibility__hint'),
    inpage_block_visibility      => d_gettext('inpage_block_visibility__hint'),
    fullscreen_block_visibility  => d_gettext('fullscreen_block_visibility__hint'),
    indoor_block_visibility      => d_gettext('indoor_block_visibility__hint'),
    outdoor_block_visibility     => d_gettext('outdoor_block_visibility__hint'),
    content_block_visibility     => d_gettext(
'The ratio of shows to the number of requests that have successfully picked ads for Content-blocks on the thematic campaigns, in percentages'
    ),
    natural_block_visibility => d_gettext(
'The ratio of shows to the number of requests that have successfully picked ads for Natural-blocks on the thematic campaigns, in percentages'
    ),
    rtb_block_visibility => d_gettext(
'The ratio of shows to the number of requests that have successfully picked ads for RTB-blocks on the thematic campaigns, in percentages'
    ),
    mobile_rtb_block_visibility => d_gettext(
'The ratio of shows to the number of requests that have successfully picked up ads for mobile RTB-blocks in applications, in percentages'
    ),
    ssp_mobile_rtb_block_visibility      => d_gettext('ssp_mobile_rtb_block_visibility__hint'),
    adblock_block_visibility             => d_gettext('adblock_block_visibility__hint'),
    instream_block_preroll_cover_ratio   => d_gettext('instream_block_preroll_cover_ratio__hint'),
    instream_block_postroll_cover_ratio  => d_gettext('instream_block_postroll_cover_ratio__hint'),
    instream_block_midroll_cover_ratio   => d_gettext('instream_block_midroll_cover_ratio__hint'),
    instream_block_pauseroll_cover_ratio => d_gettext('instream_block_pauseroll_cover_ratio__hint'),
    instream_block_cover_ratio           => d_gettext('instream_block_cover_ratio__hint'),
    inpage_block_cover_ratio             => d_gettext('inpage_block_cover_ratio__hint'),
    fullscreen_block_cover_ratio         => d_gettext('fullscreen_block_cover_ratio__hint'),
    indoor_block_cover_ratio             => d_gettext('indoor_block_cover_ratio__hint'),
    outdoor_block_cover_ratio            => d_gettext('outdoor_block_cover_ratio__hint'),
    content_block_cover_ratio            => d_gettext(
'The ratio of shows to the total number of requests for Content-blocks on the thematic campaigns, in percentages'
    ),
    natural_block_cover_ratio => d_gettext(
'The ratio of shows to the total number of requests for Natural-blocks on the thematic campaigns, in percentages'
    ),
    rtb_block_cover_ratio => d_gettext(
        'The ratio of shows to the total number of requests for RTB-blocks on the thematic campaigns, in percentages'),
    mobile_rtb_block_cover_ratio => d_gettext(
'The ratio of the number of shows to the total number of requests for the mobile RTB-blocks in applications, in percentages'
    ),
    ssp_mobile_rtb_block_cover_ratio            => d_gettext('ssp_mobile_rtb_block_cover_ratio__hint'),
    adblock_block_cover_ratio                   => d_gettext('adblock_block_cover_ratio__hint'),
    instream_block_preroll_conversion_percent   => d_gettext('instream_block_preroll_conversion_percent__hint'),
    instream_block_postroll_conversion_percent  => d_gettext('instream_block_postroll_conversion_percent__hint'),
    instream_block_midroll_conversion_percent   => d_gettext('instream_block_midroll_conversion_percent__hint'),
    instream_block_pauseroll_conversion_percent => d_gettext('instream_block_pauseroll_conversion_percent__hint'),
    instream_block_ctr                          => d_gettext('instream_block_ctr__hint'),
    instream_block_direct_ctr                   => d_gettext('instream_block_direct_ctr__hint'),
    inpage_block_direct_ctr                     => d_gettext('inpage_block_direct_ctr__hint'),
    fullscreen_block_direct_ctr                 => d_gettext('fullscreen_block_direct_ctr__hint'),
    indoor_block_direct_ctr                     => d_gettext('indoor_block_direct_ctr__hint'),
    outdoor_block_direct_ctr                    => d_gettext('outdoor_block_direct_ctr__hint'),
    content_block_direct_ctr                    => d_gettext('content_block_direct_ctr__hint'),
    natural_block_direct_ctr                    => d_gettext('natural_block_direct_ctr__hint'),
    rtb_block_direct_ctr                        => d_gettext('rtb_block_direct_ctr__hint'),
    mobile_rtb_block_direct_ctr                 => d_gettext('mobile_rtb_block_direct_ctr__hint'),
    premium_ctr                                 => d_gettext('premium_ctr__hint'),
    direct_context_ctr                          => d_gettext('direct_context_ctr__hint'),
    direct_search_ctr                           => d_gettext('direct_search_ctr__hint'),
    mcb_context_ctr                             => d_gettext('mcb_context_ctr__hint'),
    mcb_search_ctr                              => d_gettext('mcb_search_ctr__hint'),
    market_context_ctr                          => d_gettext('market_context_ctr__hint'),
    market_api_context_ctr                      => d_gettext('market_api_context_ctr__hint'),
    market_search_ctr                           => d_gettext('market_search_ctr__hint'),
    market_api_search_ctr                       => d_gettext('market_api_search_ctr__hint'),
    stripe_ctr => d_gettext('The ratio of the number of clicks by Stripe to his shows'),
    geo_id     => d_gettext('geo_id__hint'),
    (
        map {
            $_ => d_gettext('percent_content_bad_win_price_content_all__hint')
          } qw(percent_content_bad_win_price_content_all_w_nds percent_content_bad_win_price_content_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_natural_bad_win_price_natural_all__hint')
          } qw(percent_natural_bad_win_price_natural_all_w_nds percent_natural_bad_win_price_natural_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_rtb_bad_win_price_rtb_all__hint')
          } qw(percent_rtb_bad_win_price_rtb_all_w_nds percent_rtb_bad_win_price_rtb_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_content_bad_win_partner_price_content_partner__hint')
          } qw(percent_content_bad_win_partner_price_content_partner_w_nds percent_content_bad_win_partner_price_content_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_natural_bad_win_partner_price_natural_partner__hint')
          } qw(percent_natural_bad_win_partner_price_natural_partner_w_nds percent_natural_bad_win_partner_price_natural_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_rtb_bad_win_partner_price_rtb_partner__hint')
          } qw(percent_rtb_bad_win_partner_price_rtb_partner_w_nds percent_rtb_bad_win_partner_price_rtb_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_mobile_rtb_bad_win_price_mobile_rtb_all__hint')
          } qw(percent_mobile_rtb_bad_win_price_mobile_rtb_all_w_nds percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner__hint')
          } qw(percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_w_nds percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('premium_cpmh__hint')
          } qw(premium_cpmh_partner_w_nds premium_cpmh_partner_wo_nds premium_cpmh_all_w_nds premium_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_search_cpmh__hint')
          } qw(direct_search_cpmh_direct_search_partner_w_nds direct_search_cpmh_direct_search_partner_wo_nds direct_search_cpmh_direct_search_all_w_nds direct_search_cpmh_direct_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mcb_context_cpmh__hint')
          } qw(mcb_context_cpmh_mcb_context_partner_w_nds mcb_context_cpmh_mcb_context_partner_wo_nds mcb_context_cpmh_mcb_context_all_w_nds mcb_context_cpmh_mcb_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_context_cpmh__hint')
          } qw(market_context_cpmh_market_context_partner_w_nds market_context_cpmh_market_context_partner_wo_nds market_context_cpmh_market_context_all_w_nds market_context_cpmh_market_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mcb_search_cpmh__hint')
          } qw(mcb_search_cpmh_mcb_search_partner_w_nds mcb_search_cpmh_mcb_search_partner_wo_nds mcb_search_cpmh_mcb_search_all_w_nds mcb_search_cpmh_mcb_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_search_cpmh__hint')
          } qw(market_search_cpmh_market_search_partner_w_nds market_search_cpmh_market_search_partner_wo_nds market_search_cpmh_market_search_all_w_nds market_search_cpmh_market_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('content_block_rpm__hint')
          } qw(content_block_rpm_partner_w_nds content_block_rpm_partner_wo_nds content_block_rpm_all_w_nds content_block_rpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('natural_block_rpm__hint')
          } qw(natural_block_rpm_partner_w_nds natural_block_rpm_partner_wo_nds natural_block_rpm_all_w_nds natural_block_rpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('rtb_block_rpm__hint')
          } qw(rtb_block_rpm_partner_w_nds rtb_block_rpm_partner_wo_nds rtb_block_rpm_all_w_nds rtb_block_rpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mobile_rtb_block_rpm__hint')
          } qw(mobile_rtb_block_rpm_partner_w_nds mobile_rtb_block_rpm_partner_wo_nds mobile_rtb_block_rpm_all_w_nds mobile_rtb_block_rpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('ssp_mobile_rtb_block_rpm__hint')
          } qw(ssp_mobile_rtb_block_rpm_partner_w_nds ssp_mobile_rtb_block_rpm_partner_wo_nds ssp_mobile_rtb_block_rpm_all_w_nds ssp_mobile_rtb_block_rpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('adblock_block_rpm__hint')
          } qw(adblock_block_rpm_partner_w_nds adblock_block_rpm_partner_wo_nds adblock_block_rpm_all_w_nds adblock_block_rpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_context_cpmh__hint')
          } qw(direct_context_cpmh_direct_context_partner_w_nds direct_context_cpmh_direct_context_partner_wo_nds direct_context_cpmh_direct_context_all_w_nds direct_context_cpmh_direct_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('The cost of one thousand requests Stripe on thematic campaigns')
          } qw(stripe_cpmh_partner_w_nds stripe_cpmh_partner_wo_nds stripe_cpmh_all_w_nds stripe_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('instream_block_cpmh__hint')
          } qw(instream_block_cpmh_partner_w_nds instream_block_cpmh_partner_wo_nds instream_block_cpmh_all_w_nds instream_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('inpage_block_cpmh__hint')
          } qw(inpage_block_cpmh_partner_w_nds inpage_block_cpmh_partner_wo_nds inpage_block_cpmh_all_w_nds inpage_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('fullscreen_block_cpmh__hint')
          } qw(fullscreen_block_cpmh_partner_w_nds fullscreen_block_cpmh_partner_wo_nds fullscreen_block_cpmh_all_w_nds fullscreen_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('indoor_block_cpmh__hint')
          } qw(indoor_block_cpmh_partner_w_nds indoor_block_cpmh_partner_wo_nds indoor_block_cpmh_all_w_nds indoor_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('outdoor_block_cpmh__hint')
          } qw(outdoor_block_cpmh_partner_w_nds outdoor_block_cpmh_partner_wo_nds outdoor_block_cpmh_all_w_nds outdoor_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('content_block_cpmh__hint')
          } qw(content_block_cpmh_partner_w_nds content_block_cpmh_partner_wo_nds content_block_cpmh_all_w_nds content_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('natural_block_cpmh__hint')
          } qw(natural_block_cpmh_partner_w_nds natural_block_cpmh_partner_wo_nds natural_block_cpmh_all_w_nds natural_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('rtb_block_cpmh__hint')
          } qw(rtb_block_cpmh_partner_w_nds rtb_block_cpmh_partner_wo_nds rtb_block_cpmh_all_w_nds rtb_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mobile_rtb_block_cpmh__hint')
          } qw(mobile_rtb_block_cpmh_partner_w_nds mobile_rtb_block_cpmh_partner_wo_nds mobile_rtb_block_cpmh_all_w_nds mobile_rtb_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('ssp_mobile_rtb_block_cpmh__hint')
          } qw(ssp_mobile_rtb_block_cpmh_partner_w_nds ssp_mobile_rtb_block_cpmh_partner_wo_nds ssp_mobile_rtb_block_cpmh_all_w_nds ssp_mobile_rtb_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('adblock_block_cpmh__hint')
          } qw(adblock_block_cpmh_partner_w_nds adblock_block_cpmh_partner_wo_nds adblock_block_cpmh_all_w_nds adblock_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('instream_block_cpm__hint')
          } qw(instream_block_cpm_partner_w_nds instream_block_cpm_partner_wo_nds instream_block_cpm_all_w_nds instream_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('inpage_block_cpm__hint')
          } qw(inpage_block_cpm_partner_w_nds inpage_block_cpm_partner_wo_nds inpage_block_cpm_all_w_nds inpage_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('fullscreen_block_cpm__hint')
          } qw(fullscreen_block_cpm_partner_w_nds fullscreen_block_cpm_partner_wo_nds fullscreen_block_cpm_all_w_nds fullscreen_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('indoor_block_cpm__hint')
          } qw(indoor_block_cpm_partner_w_nds indoor_block_cpm_partner_wo_nds indoor_block_cpm_all_w_nds indoor_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('outdoor_block_cpm__hint')
          } qw(outdoor_block_cpm_partner_w_nds outdoor_block_cpm_partner_wo_nds outdoor_block_cpm_all_w_nds outdoor_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('content_block_cpm__hint')
          } qw(content_block_cpm_partner_w_nds content_block_cpm_partner_wo_nds content_block_cpm_all_w_nds content_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('natural_block_cpm__hint')
          } qw(natural_block_cpm_partner_w_nds natural_block_cpm_partner_wo_nds natural_block_cpm_all_w_nds natural_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('rtb_block_cpm__hint')
          } qw(rtb_block_cpm_partner_w_nds rtb_block_cpm_partner_wo_nds rtb_block_cpm_all_w_nds rtb_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mobile_rtb_block_cpm__hint')
          } qw(mobile_rtb_block_cpm_partner_w_nds mobile_rtb_block_cpm_partner_wo_nds mobile_rtb_block_cpm_all_w_nds mobile_rtb_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('ssp_mobile_rtb_block_cpm__hint')
          } qw(ssp_mobile_rtb_block_cpm_partner_w_nds ssp_mobile_rtb_block_cpm_partner_wo_nds ssp_mobile_rtb_block_cpm_all_w_nds ssp_mobile_rtb_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('adblock_block_cpm__hint')
          } qw(adblock_block_cpm_partner_w_nds adblock_block_cpm_partner_wo_nds adblock_block_cpm_all_w_nds adblock_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('premium_cpm__hint')
          } qw(premium_cpm_partner_w_nds premium_cpm_partner_wo_nds premium_cpm_all_w_nds premium_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_context_cpm__hint')
          } qw(direct_context_cpm_direct_context_partner_w_nds direct_context_cpm_direct_context_partner_wo_nds direct_context_cpm_direct_context_all_w_nds direct_context_cpm_direct_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_search_cpm__hint')
          } qw(direct_search_cpm_direct_search_partner_w_nds direct_search_cpm_direct_search_partner_wo_nds direct_search_cpm_direct_search_all_w_nds direct_search_cpm_direct_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mcb_context_cpm__hint')
          } qw(mcb_context_cpm_mcb_context_partner_w_nds mcb_context_cpm_mcb_context_partner_wo_nds mcb_context_cpm_mcb_context_all_w_nds mcb_context_cpm_mcb_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mcb_search_cpm__hint')
          } qw(mcb_search_cpm_mcb_search_partner_w_nds mcb_search_cpm_mcb_search_partner_wo_nds mcb_search_cpm_mcb_search_all_w_nds mcb_search_cpm_mcb_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_context_cpm__hint')
          } qw(market_context_cpm_market_context_partner_w_nds market_context_cpm_market_context_partner_wo_nds market_context_cpm_market_context_all_w_nds market_context_cpm_market_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_api_context_cpm__hint')
          } qw(market_api_context_cpm_market_api_context_partner_w_nds market_api_context_cpm_market_api_context_partner_wo_nds market_api_context_cpm_market_api_context_all_w_nds market_api_context_cpm_market_api_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_search_cpm__hint')
          } qw(market_search_cpm_market_search_partner_w_nds market_search_cpm_market_search_partner_wo_nds market_search_cpm_market_search_all_w_nds market_search_cpm_market_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_api_search_cpm__hint')
          } qw(market_api_search_cpm_market_api_search_partner_w_nds market_api_search_cpm_market_api_search_partner_wo_nds market_api_search_cpm_market_api_search_all_w_nds market_api_search_cpm_market_api_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('stripe_cpm__hint')
          } qw(stripe_cpm_partner_w_nds stripe_cpm_partner_wo_nds stripe_cpm_all_w_nds stripe_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext(
'Cost per mille is a commonly used measurement in advertising. Online advertising can be purchased on the basis of showing the ad to one thousand viewers.'
              )
          } qw(dsp_cpm_charging_w_nds dsp_cpm_charging_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('premium_cpc__hint')
          } qw(premium_cpc_partner_w_nds premium_cpc_partner_wo_nds premium_cpc_all_w_nds premium_cpc_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_context_cpc__hint')
          } qw(direct_context_cpc_direct_context_partner_w_nds direct_context_cpc_direct_context_partner_wo_nds direct_context_cpc_direct_context_all_w_nds direct_context_cpc_direct_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_search_cpc__hint')
          } qw(direct_search_cpc_direct_search_partner_w_nds direct_search_cpc_direct_search_partner_wo_nds direct_search_cpc_direct_search_all_w_nds direct_search_cpc_direct_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_context_cpc__hint')
          } qw(market_context_cpc_market_context_partner_w_nds market_context_cpc_market_context_partner_wo_nds market_context_cpc_market_context_all_w_nds market_context_cpc_market_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_api_context_cpc__hint')
          } qw(market_api_context_cpc_market_api_context_partner_w_nds market_api_context_cpc_market_api_context_partner_wo_nds market_api_context_cpc_market_api_context_all_w_nds market_api_context_cpc_market_api_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_search_cpc__hint')
          } qw(market_search_cpc_market_search_partner_w_nds market_search_cpc_market_search_partner_wo_nds market_search_cpc_market_search_all_w_nds market_search_cpc_market_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_api_search_cpc__hint')
          } qw(market_api_search_cpc_market_api_search_partner_w_nds market_api_search_cpc_market_api_search_partner_wo_nds market_api_search_cpc_market_api_search_all_w_nds market_api_search_cpc_market_api_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('The cost of a click by Stripe')
          } qw(stripe_cpc_partner_w_nds stripe_cpc_partner_wo_nds stripe_cpc_all_w_nds stripe_cpc_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('The ratio of the number of betting partner to participate in the bidding.')
          } qw(average_rate_all_real_price_w_nds average_rate_all_real_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('instream_partner__hint')
          } qw(instream_partner_w_nds instream_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('inpage_partner__hint')
          } qw(inpage_partner_w_nds inpage_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('fullscreen_partner__hint')
          } qw(fullscreen_partner_w_nds fullscreen_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('indoor_partner__hint')
          } qw(indoor_partner_w_nds indoor_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('outdoor_partner__hint')
          } qw(outdoor_partner_w_nds outdoor_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Remuneration of the partner for ads in Content-blocks on thematic campaigns')
          } qw(content_partner_w_nds content_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Remuneration of the partner for ads in Natural-blocks on thematic campaigns')
          } qw(natural_partner_w_nds natural_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Remuneration of the partner for ads in RTB-blocks on thematic campaigns')
          } qw(rtb_partner_w_nds rtb_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('content_bad_win_partner_price__hint')
          } qw(content_bad_win_partner_price_w_nds content_bad_win_partner_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('natural_bad_win_partner_price__hint')
          } qw(natural_bad_win_partner_price_w_nds natural_bad_win_partner_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('rtb_bad_win_partner_price__hint')
          } qw(rtb_bad_win_partner_price_w_nds rtb_bad_win_partner_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Amount of money earned by partner by RTB Mobile.')
          } qw(mobile_rtb_partner_w_nds mobile_rtb_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mobile_rtb_bad_win_partner_price__hint')
          } qw(mobile_rtb_bad_win_partner_price_w_nds mobile_rtb_bad_win_partner_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('ssp_mobile_rtb_partner__hint')
          } qw(ssp_mobile_rtb_partner_w_nds ssp_mobile_rtb_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('adblock_partner__hint')
          } qw(adblock_partner_w_nds adblock_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('premium_partner__hint')
          } qw(premium_partner_w_nds premium_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_context_partner__hint')
          } qw(direct_context_partner_w_nds direct_context_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_search_partner__hint')
          } qw(direct_search_partner_w_nds direct_search_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mcb_context_partner__hint')
          } qw(mcb_context_partner_w_nds mcb_context_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mcb_search_partner__hint')
          } qw(mcb_search_partner_w_nds mcb_search_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_context_partner__hint')
          } qw(market_context_partner_w_nds market_context_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_api_context_partner__hint')
          } qw(market_api_context_partner_w_nds market_api_context_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_search_partner__hint')
          } qw(market_search_partner_w_nds market_search_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_api_search_partner__hint')
          } qw(market_api_search_partner_w_nds market_api_search_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('The total remuneration of the partner for Stripes')
          } qw(stripe_partner_w_nds stripe_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('partner__hint')
          } qw(partner_w_nds partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('bad_win_partner_price__hint')
          } qw(bad_win_partner_price_w_nds bad_win_partner_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('instream_all__hint')
          } qw(instream_all_w_nds instream_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('inpage_all__hint')
          } qw(inpage_all_w_nds inpage_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('fullscreen_all__hint')
          } qw(fullscreen_all_w_nds fullscreen_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('indoor_all__hint')
          } qw(indoor_all_w_nds indoor_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('outdoor_all__hint')
          } qw(outdoor_all_w_nds outdoor_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Overall turnover decommissioned advertisers')
          } qw(content_all_w_nds content_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Overall turnover decommissioned advertisers')
          } qw(natural_all_w_nds natural_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Overall turnover decommissioned advertisers')
          } qw(rtb_all_w_nds rtb_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('content_bad_win_price__hint')
          } qw(content_bad_win_price_w_nds content_bad_win_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('natural_bad_win_price__hint')
          } qw(natural_bad_win_price_w_nds natural_bad_win_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('rtb_bad_win_price__hint')
          } qw(rtb_bad_win_price_w_nds rtb_bad_win_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Overall turnover decommissioned advertisers')
          } qw(mobile_rtb_all_w_nds mobile_rtb_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mobile_rtb_bad_win_price__hint')
          } qw(mobile_rtb_bad_win_price_w_nds mobile_rtb_bad_win_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('ssp_mobile_rtb_all__hint')
          } qw(ssp_mobile_rtb_all_w_nds ssp_mobile_rtb_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('adblock_all__hint')
          } qw(adblock_all_w_nds adblock_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Complete turnover of money, advertisers charge.')
          } qw(premium_all_w_nds premium_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_context_all__hint')
          } qw(direct_context_all_w_nds direct_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_search_all__hint')
          } qw(direct_search_all_w_nds direct_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mcb_context_all__hint')
          } qw(mcb_context_all_w_nds mcb_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mcb_search_all__hint')
          } qw(mcb_search_all_w_nds mcb_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_context_all__hint')
          } qw(market_context_all_w_nds market_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_api_context_all__hint')
          } qw(market_api_context_all_w_nds market_api_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_search_all__hint')
          } qw(market_search_all_w_nds market_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_api_search_all__hint')
          } qw(market_api_search_all_w_nds market_api_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Complete turnover of money, advertisers charge.')
          } qw(stripe_all_w_nds stripe_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('all__hint')
          } qw(all_w_nds all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Charging partner in accordance with the service rendered')
          } qw(dsp_charging_w_nds dsp_charging_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('The sum of all bids partner per day')
          } qw(all_real_price_w_nds all_real_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Charging partner in accordance with the service rendered')
          } qw(charging_w_nds charging_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Complete turnover of money, advertisers charge.')
          } qw(bk_price_w_nds bk_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Amount of money earned by partner by Video.')
          } qw(bk_partner_price_w_nds bk_partner_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('bad_win_price__hint')
          } qw(bad_win_price_w_nds bad_win_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('video_an_site_sum_partner__hint')
          } qw(video_an_site_sum_partner_w_nds video_an_site_sum_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('indoor_sum_partner__hint')
          } qw(indoor_sum_partner_w_nds indoor_sum_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('outdoor_sum_partner__hint')
          } qw(outdoor_sum_partner_w_nds outdoor_sum_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('video_an_site_sum_all__hint')
          } qw(video_an_site_sum_all_w_nds video_an_site_sum_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('indoor_sum_all__hint')
          } qw(indoor_sum_all_w_nds indoor_sum_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('outdoor_sum_all__hint')
          } qw(outdoor_sum_all_w_nds outdoor_sum_all_wo_nds)
    ),
    additional_income_partner => d_gettext('additional_income_partner__hint'),
    (
        map {
            $_ => sub {''}
          } qw(instream_block_win_hits inpage_block_win_hits fullscreen_block_win_hits indoor_block_win_hits outdoor_block_win_hits instream_block_win_hits_own_adv inpage_block_win_hits_own_adv fullscreen_block_win_hits_own_adv indoor_block_win_hits_own_adv outdoor_block_win_hits_own_adv instream_block_win_hits_unsold inpage_block_win_hits_unsold fullscreen_block_win_hits_unsold indoor_block_win_hits_unsold outdoor_block_win_hits_unsold)
    ),
};

TRUE;
