package Application::Model::Statistics::Fields::Titles;

use qbit;

use base qw(Exporter);

our @EXPORT = qw($TITLES);

our $RENAME_PARTNER_SHARE = FALSE;

our $TITLES = {
    instream_partner =>
      sub {$RENAME_PARTNER_SHARE ? gettext('instream_partner__title') : gettext('instream_partner__title_manager')},
    inpage_partner =>
      sub {$RENAME_PARTNER_SHARE ? gettext('inpage_partner__title') : gettext('inpage_partner__title_manager')},
    fullscreen_partner =>
      sub {$RENAME_PARTNER_SHARE ? gettext('fullscreen_partner__title') : gettext('fullscreen_partner__title_manager')},
    indoor_partner =>
      sub {$RENAME_PARTNER_SHARE ? gettext('indoor_partner__title') : gettext('indoor_partner__title_manager')},
    outdoor_partner =>
      sub {$RENAME_PARTNER_SHARE ? gettext('outdoor_partner__title') : gettext('outdoor_partner__title_manager')},
    instream_bad_win_partner_price => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('instream_bad_win_partner_price__title')
          : gettext('instream_bad_win_partner_price__title_manager');
    },
    inpage_bad_win_partner_price => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('inpage_bad_win_partner_price__title')
          : gettext('inpage_bad_win_partner_price__title_manager');
    },
    fullscreen_bad_win_partner_price => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('fullscreen_bad_win_partner_price__title')
          : gettext('fullscreen_bad_win_partner_price__title_manager');
    },
    indoor_bad_win_partner_price => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('indoor_bad_win_partner_price__title')
          : gettext('indoor_bad_win_partner_price__title_manager');
    },
    outdoor_bad_win_partner_price => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('outdoor_bad_win_partner_price__title')
          : gettext('outdoor_bad_win_partner_price__title_manager');
    },
    content_partner => sub {
        $RENAME_PARTNER_SHARE ? gettext('Remuneration by Content') : gettext('Partnerships for Content-blocks');
    },
    natural_partner => sub {
        $RENAME_PARTNER_SHARE ? gettext('Remuneration by Natural') : gettext('Partnerships for Natural-blocks');
    },
    content_bad_win_partner_price => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('content_bad_win_partner_price__title')
          : gettext('content_bad_win_partner_price__title_manager');
    },
    natural_bad_win_partner_price => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('natural_bad_win_partner_price__title')
          : gettext('natural_bad_win_partner_price__title_manager');
    },
    rtb_partner => sub {
        $RENAME_PARTNER_SHARE ? gettext('Remuneration by RTB') : gettext('Partnerships for RTB-blocks');
    },
    rtb_bad_win_partner_price => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('rtb_bad_win_partner_price__title')
          : gettext('rtb_bad_win_partner_price__title_manager');
    },
    mobile_rtb_partner => sub {
        $RENAME_PARTNER_SHARE ? gettext('Remuneration by RTB Mobile') : gettext('Partner share by RTB Mobile');
    },
    mobile_rtb_bad_win_partner_price => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('mobile_rtb_bad_win_partner_price__title')
          : gettext('mobile_rtb_bad_win_partner_price__title_manager');
    },
    ssp_mobile_rtb_partner => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('ssp_mobile_rtb_partner__title')
          : gettext('ssp_mobile_rtb_partner__title_manager');
    },
    ssp_context_rtb_partner => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('ssp_context_rtb_partner__title')
          : gettext('ssp_context_rtb_partner__title_manager');
    },
    adblock_partner => sub {
        $RENAME_PARTNER_SHARE ? gettext('adblock_partner__title') : gettext('adblock_partner__title_manager');
    },
    premium_partner => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('premium_partner__title')
          : gettext('premium_partner__title_manager');
    },
    direct_context_partner => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('direct_context_partner__title')
          : gettext('direct_context_partner__title_manager');
    },
    direct_search_partner => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('direct_search_partner__title')
          : gettext('direct_search_partner__title_manager');
    },
    mcb_context_partner => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('mcb_context_partner__title')
          : gettext('mcb_context_partner__title_manager');
    },
    mcb_search_partner => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('mcb_search_partner__title')
          : gettext('mcb_search_partner__title_manager');
    },
    market_context_partner => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('market_context_partner__title')
          : gettext('market_context_partner__title_manager');
    },
    market_api_context_partner => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('market_api_context_partner__title')
          : gettext('market_api_context_partner__title_manager');
    },
    market_search_partner => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('market_search_partner__title')
          : gettext('market_search_partner__title_manager');
    },
    market_api_search_partner => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('market_api_search_partner__title')
          : gettext('market_api_search_partner__title_manager');
    },
    stripe_partner => sub {
        $RENAME_PARTNER_SHARE ? gettext('Remuneration for Stripes') : gettext('Partnerships for Stripes');
    },
    partner => sub {
        $RENAME_PARTNER_SHARE ? gettext('partner__title') : gettext('partner__title_manager');
    },
    bad_win_partner_price => sub {
        $RENAME_PARTNER_SHARE
          ? gettext('bad_win_partner_price__title')
          : gettext('bad_win_partner_price__title_manager');
    },
    rs_all                                    => d_gettext('Turnover by RS'),
    instream_all                              => d_gettext('instream_all__title'),
    inpage_all                                => d_gettext('inpage_all__title'),
    fullscreen_all                            => d_gettext('fullscreen_all__title'),
    indoor_all                                => d_gettext('indoor_all__title'),
    outdoor_all                               => d_gettext('outdoor_all__title'),
    instream_bad_win_price                    => d_gettext('instream_bad_win_price__title'),
    inpage_bad_win_price                      => d_gettext('inpage_bad_win_price__title'),
    fullscreen_bad_win_price                  => d_gettext('fullscreen_bad_win_price__title'),
    indoor_bad_win_price                      => d_gettext('indoor_bad_win_price__title'),
    outdoor_bad_win_price                     => d_gettext('outdoor_bad_win_price__title'),
    content_all                               => d_gettext('Turnover for Content-blocks'),
    natural_all                               => d_gettext('Turnover for Natural-blocks'),
    content_bad_win_price                     => d_gettext('content_bad_win_price__title'),
    natural_bad_win_price                     => d_gettext('natural_bad_win_price__title'),
    rtb_all                                   => d_gettext('Turnover for RTB-blocks'),
    rtb_bad_win_price                         => d_gettext('rtb_bad_win_price__title'),
    mobile_rtb_all                            => d_gettext('Turnover in mobile applications'),
    mobile_rtb_bad_win_price                  => d_gettext('mobile_rtb_bad_win_price__title'),
    ssp_mobile_rtb_all                        => d_gettext('ssp_mobile_rtb_all__title'),
    ssp_context_rtb_all                       => d_gettext('ssp_context_rtb_all__title'),
    adblock_all                               => d_gettext('adblock_all__title'),
    premium_all                               => d_gettext('Premium turnover'),
    direct_context_all                        => d_gettext('direct_context_all__title'),
    direct_search_all                         => d_gettext('direct_search_all__title'),
    mcb_context_all                           => d_gettext('mcb_context_all__title'),
    mcb_search_all                            => d_gettext('mcb_search_all__title'),
    market_context_all                        => d_gettext('market_context_all__title'),
    market_api_context_all                    => d_gettext('market_api_context_all__title'),
    market_search_all                         => d_gettext('market_search_all__title'),
    market_api_search_all                     => d_gettext('market_api_search_all__title'),
    stripe_all                                => d_gettext('Stripe turnover'),
    all                                       => d_gettext('all__title'),
    dsp_charging                              => d_gettext('DSP charging'),
    all_real_price                            => d_gettext("Partner's bet"),
    charging                                  => d_gettext('Charging total'),
    bk_price                                  => d_gettext('Video turnover(from BK)'),
    bk_partner_price                          => d_gettext('Remuneration'),
    bad_win_price                             => d_gettext('bad_win_price__title'),
    instream_block_view                       => d_gettext('instream_block_view__title'),
    an_content_cover_hits                     => d_gettext('Auction'),
    an_natural_cover_hits                     => d_gettext('Auction'),
    an_rtb_cover_hits                         => d_gettext('Auction'),
    an_mobile_rtb_cover_hits                  => d_gettext('Mobile auction'),
    an_ssp_mobile_rtb_cover_hits              => d_gettext('SSP mobile auction'),
    dsp_bids                                  => d_gettext('Won auctions'),
    an_content_cover_senthits                 => d_gettext('Bidding'),
    an_natural_cover_senthits                 => d_gettext('Bidding'),
    an_rtb_cover_senthits                     => d_gettext('Bidding'),
    an_mobile_rtb_cover_senthits              => d_gettext('Mobile bidding'),
    an_ssp_mobile_rtb_cover_senthits          => d_gettext('SSP mobile bidding'),
    an_cover_hits                             => d_gettext('Pages with requests'),
    direct_search_hits                        => d_gettext('Page requests search Direct'),
    mcb_search_hits                           => d_gettext('Page requests search MCB'),
    market_search_hits                        => d_gettext('Page requests search Market'),
    premium_hits                              => d_gettext('Page requests Premium'),
    an_cover_senthits                         => d_gettext('Pages with responses'),
    instream_block_open_player                => d_gettext('instream_block_open_player__title'),
    instream_block_preroll_shows              => d_gettext('instream_block_preroll_shows__title'),
    instream_block_preroll_hits               => d_gettext('instream_block_preroll_hits__title'),
    instream_block_preroll_all_hits           => d_gettext('instream_block_preroll_all_hits__title'),
    instream_block_postroll_shows             => d_gettext('instream_block_postroll_shows__title'),
    instream_block_postroll_hits              => d_gettext('instream_block_postroll_hits__title'),
    instream_block_postroll_all_hits          => d_gettext('instream_block_postroll_all_hits__title'),
    instream_block_midroll_shows              => d_gettext('instream_block_midroll_shows__title'),
    instream_block_midroll_hits               => d_gettext('instream_block_midroll_hits__title'),
    instream_block_midroll_all_hits           => d_gettext('instream_block_midroll_all_hits__title'),
    instream_block_pauseroll_shows            => d_gettext('instream_block_pauseroll_shows__title'),
    instream_block_pauseroll_hits             => d_gettext('instream_block_pauseroll_hits__title'),
    instream_block_pauseroll_all_hits         => d_gettext('instream_block_pauseroll_all_hits__title'),
    premium_page_ad_shows                     => d_gettext('Pages with Premium'),
    an_cover_direct_hits                      => d_gettext('Page with Direct and Premium shows'),
    an_cover_market_hits                      => d_gettext('Pages with market shows'),
    an_cover_mcb_hits                         => d_gettext('Pages with MCB shows'),
    premium_ads                               => d_gettext("Premium's ads"),
    direct_context_ads                        => d_gettext("Context Direct's ads"),
    direct_search_ads                         => d_gettext("Search Direct's ads"),
    an_fraud_shows                            => d_gettext('Fraud shows'),
    an_fraud_clicks                           => d_gettext('Fraud clicks'),
    an_content_cover_direct_hits              => d_gettext('Direct shows in Content-blocks'),
    an_natural_cover_direct_hits              => d_gettext('Direct shows in Natural-blocks'),
    an_rtb_cover_direct_hits                  => d_gettext('Direct shows in RTB-blocks'),
    an_mobile_rtb_cover_direct_hits           => d_gettext("Shows Direct's block in RTB Mobile"),
    an_ssp_mobile_rtb_cover_direct_hits       => d_gettext("Shows Direct's block in SSP RTB Mobile"),
    direct_context_page_ad_shows              => d_gettext('Pages with context Direct'),
    direct_search_page_ad_shows               => d_gettext('Pages with search Direct'),
    direct_ad_visibility                      => d_gettext('direct_ad_visibility__title'),
    direct_ad_reach                           => d_gettext('%&nbsp;reach Direct'),
    direct_ad_coverage                        => d_gettext('%&nbsp;coverage'),
    instream_block_hits                       => d_gettext('instream_block_hits__title'),
    inpage_block_hits                         => d_gettext('inpage_block_hits__title'),
    fullscreen_block_hits                     => d_gettext('fullscreen_block_hits__title'),
    indoor_block_hits                         => d_gettext('indoor_block_hits__title'),
    outdoor_block_hits                        => d_gettext('outdoor_block_hits__title'),
    instream_block_direct_clicks              => d_gettext('instream_block_direct_clicks__title'),
    inpage_block_direct_clicks                => d_gettext('inpage_block_direct_clicks__title'),
    fullscreen_block_direct_clicks            => d_gettext('fullscreen_block_direct_clicks__title'),
    indoor_block_direct_clicks                => d_gettext('indoor_block_direct_clicks__title'),
    outdoor_block_direct_clicks               => d_gettext('outdoor_block_direct_clicks__title'),
    video_bk_hits                             => d_gettext('Request video block'),
    content_block_hits                        => d_gettext('content_block_hits__title'),
    content_block_bad_win_hits                => d_gettext('content_block_bad_win_hits__title'),
    natural_block_hits                        => d_gettext('natural_block_hits__title'),
    natural_block_bad_win_hits                => d_gettext('natural_block_bad_win_hits__title'),
    instream_block_bad_win_hits               => d_gettext('instream_block_bad_win_hits__title'),
    inpage_block_bad_win_hits                 => d_gettext('inpage_block_bad_win_hits__title'),
    fullscreen_block_bad_win_hits             => d_gettext('fullscreen_block_bad_win_hits__title'),
    indoor_block_bad_win_hits                 => d_gettext('indoor_block_bad_win_hits__title'),
    outdoor_block_bad_win_hits                => d_gettext('outdoor_block_bad_win_hits__title'),
    rtb_block_hits                            => d_gettext('rtb_block_hits__title'),
    rtb_block_bad_win_hits                    => d_gettext('rtb_block_bad_win_hits__title'),
    mobile_mediation_block_hits               => d_gettext('mobile_mediation_block_hits__title'),
    mobile_mediation_block_impressions        => d_gettext('mobile_mediation_block_impressions__title'),
    mobile_mediation_block_visibility         => d_gettext('mobile_mediation_block_visibility__title'),
    mobile_mediation_block_calculated_revenue => d_gettext('mobile_mediation_block_calculated_revenue__title'),
    mobile_mediation_block_calculated_revenue_original =>
      d_gettext('mobile_mediation_block_calculated_revenue_original__title'),
    mobile_rtb_block_hits                       => d_gettext('mobile_rtb_block_hits__title'),
    mobile_rtb_block_bad_win_hits               => d_gettext('mobile_rtb_block_bad_win_hits__title'),
    direct_context_hits                         => d_gettext('direct_context_hits__title'),
    mcb_context_hits                            => d_gettext('mcb_context_hits__title'),
    market_context_hits                         => d_gettext('market_context_hits__title'),
    stripe_hits                                 => d_gettext('stripe_hits__title'),
    ssp_mobile_rtb_block_hits                   => d_gettext('ssp_mobile_rtb_block_hits__title'),
    adblock_block_hits                          => d_gettext('adblock_block_hits__title'),
    instream_block_shows                        => d_gettext('instream_block_shows__title'),
    inpage_block_shows                          => d_gettext('inpage_block_shows__title'),
    fullscreen_block_shows                      => d_gettext('fullscreen_block_shows__title'),
    indoor_block_shows                          => d_gettext('indoor_block_shows__title'),
    outdoor_block_shows                         => d_gettext('outdoor_block_shows__title'),
    instream_block_bad_shows                    => d_gettext('instream_block_bad_shows__title'),
    inpage_block_bad_shows                      => d_gettext('inpage_block_bad_shows__title'),
    fullscreen_block_bad_shows                  => d_gettext('fullscreen_block_bad_shows__title'),
    indoor_block_bad_shows                      => d_gettext('indoor_block_bad_shows__title'),
    outdoor_block_bad_shows                     => d_gettext('outdoor_block_bad_shows__title'),
    instream_block_direct_shows                 => d_gettext('instream_block_direct_shows__title'),
    inpage_block_direct_shows                   => d_gettext('inpage_block_direct_shows__title'),
    fullscreen_block_direct_shows               => d_gettext('fullscreen_block_direct_shows__title'),
    indoor_block_direct_shows                   => d_gettext('indoor_block_direct_shows__title'),
    outdoor_block_direct_shows                  => d_gettext('outdoor_block_direct_shows__title'),
    video_bk_shows                              => d_gettext('Shows'),
    content_block_shows                         => d_gettext('Content-blocks shows'),
    content_block_bad_shows                     => d_gettext('content_block_bad_shows__title'),
    content_block_direct_shows                  => d_gettext('content_block_direct_shows__title'),
    natural_block_shows                         => d_gettext('Natural-blocks shows'),
    natural_block_bad_shows                     => d_gettext('natural_block_bad_shows__title'),
    natural_block_direct_shows                  => d_gettext('natural_block_direct_shows__title'),
    rtb_block_shows                             => d_gettext('RTB-blocks shows'),
    rtb_block_bad_shows                         => d_gettext('rtb_block_bad_shows__title'),
    rtb_block_direct_shows                      => d_gettext('rtb_block_direct_shows__title'),
    mobile_rtb_block_shows                      => d_gettext('Mobile RTB-blocks shows'),
    mobile_rtb_block_bad_shows                  => d_gettext('mobile_rtb_block_bad_shows__title'),
    mobile_rtb_block_direct_shows               => d_gettext('mobile_rtb_block_direct_shows__title'),
    premium_shows                               => d_gettext('Ad shows in Premium blocks'),
    direct_context_shows                        => d_gettext('direct_context_shows__title'),
    direct_search_shows                         => d_gettext('direct_search_shows__title'),
    mcb_context_shows                           => d_gettext('mcb_context_shows__title'),
    mcb_search_shows                            => d_gettext('mcb_search_shows__title'),
    market_context_shows                        => d_gettext('market_context_shows__title'),
    market_api_context_shows                    => d_gettext('market_api_context_shows__title'),
    market_search_shows                         => d_gettext('market_search_shows__title'),
    market_api_search_shows                     => d_gettext('market_api_search_shows__title'),
    stripe_shows                                => d_gettext('Stripe shows'),
    ssp_mobile_rtb_block_shows                  => d_gettext('ssp_mobile_rtb_block_shows__title'),
    adblock_block_shows                         => d_gettext('adblock_block_shows__title'),
    dsp_shows                                   => d_gettext('DSP shows'),
    content_block_direct_clicks                 => d_gettext('content_block_direct_clicks__title'),
    natural_block_direct_clicks                 => d_gettext('natural_block_direct_clicks__title'),
    rtb_block_direct_clicks                     => d_gettext('rtb_block_direct_clicks__title'),
    mobile_rtb_block_direct_clicks              => d_gettext('mobile_rtb_block_direct_clicks__title'),
    premium_clicks                              => d_gettext('Clicks in Premium blocks'),
    direct_context_clicks                       => d_gettext('direct_context_clicks__title'),
    direct_search_clicks                        => d_gettext('direct_search_clicks__title'),
    mcb_context_clicks                          => d_gettext('mcb_context_clicks__title'),
    mcb_search_clicks                           => d_gettext('mcb_search_clicks__title'),
    market_context_clicks                       => d_gettext('market_context_clicks__title'),
    market_api_context_clicks                   => d_gettext('market_api_context_clicks__title'),
    market_search_clicks                        => d_gettext('market_search_clicks__title'),
    market_api_search_clicks                    => d_gettext('market_api_search_clicks__title'),
    stripe_clicks                               => d_gettext('Stripe clicks'),
    instream_block_hits_own_adv                 => d_gettext('instream_block_hits_own_adv__title'),
    inpage_block_hits_own_adv                   => d_gettext('inpage_block_hits_own_adv__title'),
    fullscreen_block_hits_own_adv               => d_gettext('fullscreen_block_hits_own_adv__title'),
    indoor_block_hits_own_adv                   => d_gettext('indoor_block_hits_own_adv__title'),
    outdoor_block_hits_own_adv                  => d_gettext('outdoor_block_hits_own_adv__title'),
    video_bk_hits_own_adv                       => d_gettext('Hits its video advertising block'),
    content_block_hits_own_adv                  => d_gettext('Requests its advertising in Content-blocks'),
    content_block_bad_win_hits_own_adv          => d_gettext('content_block_bad_win_hits_own_adv__title'),
    natural_block_hits_own_adv                  => d_gettext('Requests its advertising in Natural-blocks'),
    natural_block_bad_win_hits_own_adv          => d_gettext('natural_block_bad_win_hits_own_adv__title'),
    inpage_block_bad_shows_own_adv              => d_gettext('inpage_block_bad_shows_own_adv__title'),
    instream_block_bad_shows_own_adv            => d_gettext('instream_block_bad_shows_own_adv__title'),
    fullscreen_block_bad_shows_own_adv          => d_gettext('fullscreen_block_bad_shows_own_adv__title'),
    indoor_block_bad_shows_own_adv              => d_gettext('indoor_block_bad_shows_own_adv__title'),
    outdoor_block_bad_shows_own_adv             => d_gettext('outdoor_block_bad_shows_own_adv__title'),
    inpage_block_bad_win_hits_own_adv           => d_gettext('inpage_block_bad_win_hits_own_adv__title'),
    instream_block_bad_win_hits_own_adv         => d_gettext('instream_block_bad_win_hits_own_adv__title'),
    fullscreen_block_bad_win_hits_own_adv       => d_gettext('fullscreen_block_bad_win_hits_own_adv__title'),
    indoor_block_bad_win_hits_own_adv           => d_gettext('indoor_block_bad_win_hits_own_adv__title'),
    outdoor_block_bad_win_hits_own_adv          => d_gettext('outdoor_block_bad_win_hits_own_adv__title'),
    rtb_block_hits_own_adv                      => d_gettext('Requests its advertising in RTB-blocks'),
    rtb_block_bad_win_hits_own_adv              => d_gettext('rtb_block_bad_win_hits_own_adv__title'),
    mobile_rtb_block_hits_own_adv               => d_gettext('Requests its advertising in mobile RTB-blocks'),
    mobile_rtb_block_bad_win_hits_own_adv       => d_gettext('mobile_rtb_block_bad_win_hits_own_adv__title'),
    ssp_mobile_rtb_block_hits_own_adv           => d_gettext('ssp_mobile_rtb_block_hits_own_adv__title'),
    adblock_block_hits_own_adv                  => d_gettext('adblock_block_hits_own_adv__title'),
    instream_block_shows_own_adv                => d_gettext('instream_block_shows_own_adv__title'),
    inpage_block_shows_own_adv                  => d_gettext('inpage_block_shows_own_adv__title'),
    fullscreen_block_shows_own_adv              => d_gettext('fullscreen_block_shows_own_adv__title'),
    indoor_block_shows_own_adv                  => d_gettext('indoor_block_shows_own_adv__title'),
    outdoor_block_shows_own_adv                 => d_gettext('outdoor_block_shows_own_adv__title'),
    video_bk_shows_own_adv                      => d_gettext('Shows its video advertising block'),
    content_block_shows_own_adv                 => d_gettext('Shows its advertising in Content-blocks'),
    content_block_bad_shows_own_adv             => d_gettext('content_block_bad_shows_own_adv__title'),
    natural_block_shows_own_adv                 => d_gettext('Shows its advertising in Natural-blocks'),
    natural_block_bad_shows_own_adv             => d_gettext('natural_block_bad_shows_own_adv__title'),
    rtb_block_shows_own_adv                     => d_gettext('Shows its advertising in RTB-blocks'),
    rtb_block_bad_shows_own_adv                 => d_gettext('rtb_block_bad_shows_own_adv__title'),
    mobile_rtb_block_shows_own_adv              => d_gettext('Shows its advertising in mobile RTB-blocks'),
    mobile_rtb_block_bad_shows_own_adv          => d_gettext('mobile_rtb_block_bad_shows_own_adv__title'),
    adblock_block_shows_own_adv                 => d_gettext('adblock_block_shows_own_adv__title'),
    instream_block_hits_unsold                  => d_gettext('instream_block_hits_unsold__title'),
    inpage_block_hits_unsold                    => d_gettext('inpage_block_hits_unsold__title'),
    fullscreen_block_hits_unsold                => d_gettext('fullscreen_block_hits_unsold__title'),
    indoor_block_hits_unsold                    => d_gettext('indoor_block_hits_unsold__title'),
    outdoor_block_hits_unsold                   => d_gettext('outdoor_block_hits_unsold__title'),
    video_bk_hits_unsold                        => d_gettext('Unsold hits video block'),
    content_block_hits_unsold                   => d_gettext('Unsold requests Content-blocks'),
    content_block_bad_win_hits_unsold           => d_gettext('content_block_bad_win_hits_unsold__title'),
    natural_block_hits_unsold                   => d_gettext('Unsold requests Natural-blocks'),
    natural_block_bad_win_hits_unsold           => d_gettext('natural_block_bad_win_hits_unsold__title'),
    inpage_block_bad_win_hits_unsold            => d_gettext('inpage_block_bad_win_hits_unsold__title'),
    instream_block_bad_win_hits_unsold          => d_gettext('instream_block_bad_win_hits_unsold__title'),
    fullscreen_block_bad_win_hits_unsold        => d_gettext('fullscreen_block_bad_win_hits_unsold__title'),
    indoor_block_bad_win_hits_unsold            => d_gettext('indoor_block_bad_win_hits_unsold__title'),
    outdoor_block_bad_win_hits_unsold           => d_gettext('outdoor_block_bad_win_hits_unsold__title'),
    rtb_block_hits_unsold                       => d_gettext('Unsold requests RTB-blocks'),
    rtb_block_bad_win_hits_unsold               => d_gettext('rtb_block_bad_win_hits_unsold__title'),
    mobile_rtb_block_hits_unsold                => d_gettext('Unsold requests mobile RTB-blocks'),
    mobile_rtb_block_bad_win_hits_unsold        => d_gettext('mobile_rtb_block_bad_win_hits_unsold__title'),
    ssp_mobile_rtb_block_hits_unsold            => d_gettext('ssp_mobile_rtb_block_hits_unsold__title'),
    adblock_block_hits_unsold                   => d_gettext('adblock_block_hits_unsold__title'),
    video_an_site_all_hits                      => d_gettext('video_an_site_all_hits__title'),
    video_an_site_all_shows                     => d_gettext('video_an_site_all_shows__title'),
    video_an_site_all_hits_own_adv              => d_gettext('video_an_site_all_hits_own_adv__title'),
    video_an_site_all_shows_own_adv             => d_gettext('video_an_site_all_shows_own_adv__title'),
    video_an_site_all_hits_unsold               => d_gettext('video_an_site_all_hits_unsold__title'),
    indoor_all_hits                             => d_gettext('indoor_all_hits__title'),
    indoor_all_shows                            => d_gettext('indoor_all_shows__title'),
    indoor_all_hits_own_adv                     => d_gettext('indoor_all_hits_own_adv__title'),
    indoor_all_shows_own_adv                    => d_gettext('indoor_all_shows_own_adv__title'),
    indoor_all_hits_unsold                      => d_gettext('indoor_all_hits_unsold__title'),
    outdoor_all_hits                            => d_gettext('outdoor_all_hits__title'),
    outdoor_all_shows                           => d_gettext('outdoor_all_shows__title'),
    outdoor_all_hits_own_adv                    => d_gettext('outdoor_all_hits_own_adv__title'),
    outdoor_all_shows_own_adv                   => d_gettext('outdoor_all_shows_own_adv__title'),
    outdoor_all_hits_unsold                     => d_gettext('outdoor_all_hits_unsold__title'),
    instream_block_all_hits                     => d_gettext('instream_block_all_hits__title'),
    inpage_block_all_hits                       => d_gettext('inpage_block_all_hits__title'),
    fullscreen_block_all_hits                   => d_gettext('fullscreen_block_all_hits__title'),
    indoor_block_all_hits                       => d_gettext('indoor_block_all_hits__title'),
    outdoor_block_all_hits                      => d_gettext('outdoor_block_all_hits__title'),
    video_an_site_sum_all_hits                  => d_gettext('video_an_site_sum_all_hits__title'),
    indoor_sum_all_hits                         => d_gettext('indoor_sum_all_hits__title'),
    outdoor_sum_all_hits                        => d_gettext('outdoor_sum_all_hits__title'),
    video_bk_all_hits                           => d_gettext('The sum of all hits'),
    content_block_all_hits                      => d_gettext('content_block_all_hits__title'),
    natural_block_all_hits                      => d_gettext('natural_block_all_hits__title'),
    rtb_block_all_hits                          => d_gettext('rtb_block_all_hits__title'),
    mobile_rtb_block_all_hits                   => d_gettext('mobile_rtb_block_all_hits__title'),
    ssp_mobile_rtb_block_all_hits               => d_gettext('ssp_mobile_rtb_block_all_hits__title'),
    adblock_block_all_hits                      => d_gettext('adblock_block_all_hits__title'),
    all_hits                                    => d_gettext('Participation in an auction'),
    content_block_bad_win_hits_percent          => d_gettext('content_block_bad_win_hits_percent__title'),
    natural_block_bad_win_hits_percent          => d_gettext('natural_block_bad_win_hits_percent__title'),
    inpage_block_bad_win_hits_percent           => d_gettext('inpage_block_bad_win_hits_percent__title'),
    instream_block_bad_win_hits_percent         => d_gettext('instream_block_bad_win_hits_percent__title'),
    fullscreen_block_bad_win_hits_percent       => d_gettext('fullscreen_block_bad_win_hits_percent__title'),
    indoor_block_bad_win_hits_percent           => d_gettext('indoor_block_bad_win_hits_percent__title'),
    outdoor_block_bad_win_hits_percent          => d_gettext('outdoor_block_bad_win_hits_percent__title'),
    rtb_block_bad_win_hits_percent              => d_gettext('rtb_block_bad_win_hits_percent__title'),
    mobile_rtb_block_bad_win_hits_percent       => d_gettext('mobile_rtb_block_bad_win_hits_percent__title'),
    content_block_bad_shows_percent             => d_gettext('content_block_bad_shows_percent__title'),
    natural_block_bad_shows_percent             => d_gettext('natural_block_bad_shows_percent__title'),
    inpage_block_bad_shows_percent              => d_gettext('inpage_block_bad_shows_percent__title'),
    instream_block_bad_shows_percent            => d_gettext('instream_block_bad_shows_percent__title'),
    fullscreen_block_bad_shows_percent          => d_gettext('fullscreen_block_bad_shows_percent__title'),
    indoor_block_bad_shows_percent              => d_gettext('indoor_block_bad_shows_percent__title'),
    outdoor_block_bad_shows_percent             => d_gettext('outdoor_block_bad_shows_percent__title'),
    rtb_block_bad_shows_percent                 => d_gettext('rtb_block_bad_shows_percent__title'),
    mobile_rtb_block_bad_shows_percent          => d_gettext('mobile_rtb_block_bad_shows_percent__title'),
    instream_block_winrate                      => d_gettext('instream_block_winrate__title'),
    inpage_block_winrate                        => d_gettext('inpage_block_winrate__title'),
    fullscreen_block_winrate                    => d_gettext('fullscreen_block_winrate__title'),
    indoor_block_winrate                        => d_gettext('indoor_block_winrate__title'),
    outdoor_block_winrate                       => d_gettext('outdoor_block_winrate__title'),
    content_block_winrate                       => d_gettext('Fill rate Content-blocks'),
    natural_block_winrate                       => d_gettext('Fill rate Natural-blocks'),
    rtb_block_winrate                           => d_gettext('Fill rate RTB-blocks'),
    mobile_rtb_block_winrate                    => d_gettext('Fill rate mobile RTB-blocks'),
    ssp_mobile_rtb_block_winrate                => d_gettext('ssp_mobile_rtb_block_winrate__title'),
    adblock_block_winrate                       => d_gettext('adblock_block_winrate__title'),
    instream_block_visibility                   => d_gettext('instream_block_visibility__title'),
    inpage_block_visibility                     => d_gettext('inpage_block_visibility__title'),
    fullscreen_block_visibility                 => d_gettext('fullscreen_block_visibility__title'),
    indoor_block_visibility                     => d_gettext('indoor_block_visibility__title'),
    outdoor_block_visibility                    => d_gettext('outdoor_block_visibility__title'),
    content_block_visibility                    => d_gettext('%&nbsp;Content-blocks visibility'),
    natural_block_visibility                    => d_gettext('%&nbsp;Natural-blocks visibility'),
    rtb_block_visibility                        => d_gettext('%&nbsp;RTB-blocks visibility'),
    mobile_rtb_block_visibility                 => d_gettext('%&nbsp;mobile RTB-blocks visibility'),
    ssp_mobile_rtb_block_visibility             => d_gettext('ssp_mobile_rtb_block_visibility__title'),
    adblock_block_visibility                    => d_gettext('adblock_block_visibility__title'),
    instream_block_preroll_cover_ratio          => d_gettext('instream_block_preroll_cover_ratio__title'),
    instream_block_postroll_cover_ratio         => d_gettext('instream_block_postroll_cover_ratio__title'),
    instream_block_midroll_cover_ratio          => d_gettext('instream_block_midroll_cover_ratio__title'),
    instream_block_pauseroll_cover_ratio        => d_gettext('instream_block_pauseroll_cover_ratio__title'),
    instream_block_cover_ratio                  => d_gettext('instream_block_cover_ratio__title'),
    inpage_block_cover_ratio                    => d_gettext('inpage_block_cover_ratio__title'),
    fullscreen_block_cover_ratio                => d_gettext('fullscreen_block_cover_ratio__title'),
    indoor_block_cover_ratio                    => d_gettext('indoor_block_cover_ratio__title'),
    outdoor_block_cover_ratio                   => d_gettext('outdoor_block_cover_ratio__title'),
    content_block_cover_ratio                   => d_gettext('Fill rate Content-blocks based on check visibility'),
    natural_block_cover_ratio                   => d_gettext('Fill rate Natural-blocks based on check visibility'),
    rtb_block_cover_ratio                       => d_gettext('Fill rate RTB-blocks based on check visibility'),
    mobile_rtb_block_cover_ratio                => d_gettext('Fill rate mobile RTB-blocks based on check visibility'),
    ssp_mobile_rtb_block_cover_ratio            => d_gettext('ssp_mobile_rtb_block_cover_ratio__title'),
    adblock_block_cover_ratio                   => d_gettext('adblock_block_cover_ratio__title'),
    instream_block_preroll_conversion_percent   => d_gettext('instream_block_preroll_conversion_percent__title'),
    instream_block_postroll_conversion_percent  => d_gettext('instream_block_postroll_conversion_percent__title'),
    instream_block_midroll_conversion_percent   => d_gettext('instream_block_midroll_conversion_percent__title'),
    instream_block_pauseroll_conversion_percent => d_gettext('instream_block_pauseroll_conversion_percent__title'),
    instream_block_ctr                          => d_gettext('instream_block_ctr__title'),
    instream_block_direct_ctr                   => d_gettext('instream_block_direct_ctr__title'),
    inpage_block_direct_ctr                     => d_gettext('inpage_block_direct_ctr__title'),
    fullscreen_block_direct_ctr                 => d_gettext('fullscreen_block_direct_ctr__title'),
    indoor_block_direct_ctr                     => d_gettext('indoor_block_direct_ctr__title'),
    outdoor_block_direct_ctr                    => d_gettext('outdoor_block_direct_ctr__title'),
    content_block_direct_ctr                    => d_gettext('content_block_direct_ctr__title'),
    natural_block_direct_ctr                    => d_gettext('natural_block_direct_ctr__title'),
    rtb_block_direct_ctr                        => d_gettext('rtb_block_direct_ctr__title'),
    mobile_rtb_block_direct_ctr                 => d_gettext('mobile_rtb_block_direct_ctr__title'),
    premium_ctr                                 => d_gettext('premium_ctr__title'),
    direct_context_ctr                          => d_gettext('direct_context_ctr__title'),
    direct_search_ctr                           => d_gettext('direct_search_ctr__title'),
    mcb_context_ctr                             => d_gettext('mcb_context_ctr__title'),
    mcb_search_ctr                              => d_gettext('mcb_search_ctr__title'),
    market_context_ctr                          => d_gettext('market_context_ctr__title'),
    market_api_context_ctr                      => d_gettext('market_api_context_ctr__title'),
    market_search_ctr                           => d_gettext('market_search_ctr__title'),
    market_api_search_ctr                       => d_gettext('market_api_search_ctr__title'),
    stripe_ctr                                  => d_gettext('Stripe CTR'),
    geo_id                                      => d_gettext('geo_id__title'),
    (
        map {
            $_ => d_gettext('percent_content_bad_win_price_content_all__title')
          } qw(percent_content_bad_win_price_content_all_w_nds percent_content_bad_win_price_content_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_natural_bad_win_price_natural_all__title')
          } qw(percent_natural_bad_win_price_natural_all_w_nds percent_natural_bad_win_price_natural_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_rtb_bad_win_price_rtb_all__title')
          } qw(percent_rtb_bad_win_price_rtb_all_w_nds percent_rtb_bad_win_price_rtb_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_content_bad_win_partner_price_content_partner__title')
          } qw(percent_content_bad_win_partner_price_content_partner_w_nds percent_content_bad_win_partner_price_content_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_natural_bad_win_partner_price_natural_partner__title')
          } qw(percent_natural_bad_win_partner_price_natural_partner_w_nds percent_natural_bad_win_partner_price_natural_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_rtb_bad_win_partner_price_rtb_partner__title')
          } qw(percent_rtb_bad_win_partner_price_rtb_partner_w_nds percent_rtb_bad_win_partner_price_rtb_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_mobile_rtb_bad_win_price_mobile_rtb_all__title')
          } qw(percent_mobile_rtb_bad_win_price_mobile_rtb_all_w_nds percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner__title')
          } qw(percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_w_nds percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('premium_cpmh__title')
          } qw(premium_cpmh_partner_w_nds premium_cpmh_partner_wo_nds premium_cpmh_all_w_nds premium_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_search_cpmh__title')
          } qw(direct_search_cpmh_direct_search_partner_w_nds direct_search_cpmh_direct_search_partner_wo_nds direct_search_cpmh_direct_search_all_w_nds direct_search_cpmh_direct_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mcb_context_cpmh__title')
          } qw(mcb_context_cpmh_mcb_context_partner_w_nds mcb_context_cpmh_mcb_context_partner_wo_nds mcb_context_cpmh_mcb_context_all_w_nds mcb_context_cpmh_mcb_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_context_cpmh__title')
          } qw(market_context_cpmh_market_context_partner_w_nds market_context_cpmh_market_context_partner_wo_nds market_context_cpmh_market_context_all_w_nds market_context_cpmh_market_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mcb_search_cpmh__title')
          } qw(mcb_search_cpmh_mcb_search_partner_w_nds mcb_search_cpmh_mcb_search_partner_wo_nds mcb_search_cpmh_mcb_search_all_w_nds mcb_search_cpmh_mcb_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_search_cpmh__title')
          } qw(market_search_cpmh_market_search_partner_w_nds market_search_cpmh_market_search_partner_wo_nds market_search_cpmh_market_search_all_w_nds market_search_cpmh_market_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('content_block_rpm__title')
          } qw(content_block_rpm_partner_w_nds content_block_rpm_partner_wo_nds content_block_rpm_all_w_nds content_block_rpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('natural_block_rpm__title')
          } qw(natural_block_rpm_partner_w_nds natural_block_rpm_partner_wo_nds natural_block_rpm_all_w_nds natural_block_rpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('rtb_block_rpm__title')
          } qw(rtb_block_rpm_partner_w_nds rtb_block_rpm_partner_wo_nds rtb_block_rpm_all_w_nds rtb_block_rpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mobile_rtb_block_rpm__title')
          } qw(mobile_rtb_block_rpm_partner_w_nds mobile_rtb_block_rpm_partner_wo_nds mobile_rtb_block_rpm_all_w_nds mobile_rtb_block_rpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('ssp_mobile_rtb_block_rpm__title')
          } qw(ssp_mobile_rtb_block_rpm_partner_w_nds ssp_mobile_rtb_block_rpm_partner_wo_nds ssp_mobile_rtb_block_rpm_all_w_nds ssp_mobile_rtb_block_rpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('adblock_block_rpm__title')
          } qw(adblock_block_rpm_partner_w_nds adblock_block_rpm_partner_wo_nds adblock_block_rpm_all_w_nds adblock_block_rpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_context_cpmh__title')
          } qw(direct_context_cpmh_direct_context_partner_w_nds direct_context_cpmh_direct_context_partner_wo_nds direct_context_cpmh_direct_context_all_w_nds direct_context_cpmh_direct_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Stripe CPMH')
          } qw(stripe_cpmh_partner_w_nds stripe_cpmh_partner_wo_nds stripe_cpmh_all_w_nds stripe_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('instream_block_cpmh__title')
          } qw(instream_block_cpmh_partner_w_nds instream_block_cpmh_partner_wo_nds instream_block_cpmh_all_w_nds instream_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('inpage_block_cpmh__title')
          } qw(inpage_block_cpmh_partner_w_nds inpage_block_cpmh_partner_wo_nds inpage_block_cpmh_all_w_nds inpage_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('fullscreen_block_cpmh__title')
          } qw(fullscreen_block_cpmh_partner_w_nds fullscreen_block_cpmh_partner_wo_nds fullscreen_block_cpmh_all_w_nds fullscreen_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('indoor_block_cpmh__title')
          } qw(indoor_block_cpmh_partner_w_nds indoor_block_cpmh_partner_wo_nds indoor_block_cpmh_all_w_nds indoor_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('outdoor_block_cpmh__title')
          } qw(outdoor_block_cpmh_partner_w_nds outdoor_block_cpmh_partner_wo_nds outdoor_block_cpmh_all_w_nds outdoor_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('content_block_cpmh__title')
          } qw(content_block_cpmh_partner_w_nds content_block_cpmh_partner_wo_nds content_block_cpmh_all_w_nds content_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('natural_block_cpmh__title')
          } qw(natural_block_cpmh_partner_w_nds natural_block_cpmh_partner_wo_nds natural_block_cpmh_all_w_nds natural_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('rtb_block_cpmh__title')
          } qw(rtb_block_cpmh_partner_w_nds rtb_block_cpmh_partner_wo_nds rtb_block_cpmh_all_w_nds rtb_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mobile_rtb_block_cpmh__title')
          } qw(mobile_rtb_block_cpmh_partner_w_nds mobile_rtb_block_cpmh_partner_wo_nds mobile_rtb_block_cpmh_all_w_nds mobile_rtb_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('ssp_mobile_rtb_block_cpmh__title')
          } qw(ssp_mobile_rtb_block_cpmh_partner_w_nds ssp_mobile_rtb_block_cpmh_partner_wo_nds ssp_mobile_rtb_block_cpmh_all_w_nds ssp_mobile_rtb_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('adblock_block_cpmh__title')
          } qw(adblock_block_cpmh_partner_w_nds adblock_block_cpmh_partner_wo_nds adblock_block_cpmh_all_w_nds adblock_block_cpmh_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('instream_block_cpm__title')
          } qw(instream_block_cpm_partner_w_nds instream_block_cpm_partner_wo_nds instream_block_cpm_all_w_nds instream_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('inpage_block_cpm__title')
          } qw(inpage_block_cpm_partner_w_nds inpage_block_cpm_partner_wo_nds inpage_block_cpm_all_w_nds inpage_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('fullscreen_block_cpm__title')
          } qw(fullscreen_block_cpm_partner_w_nds fullscreen_block_cpm_partner_wo_nds fullscreen_block_cpm_all_w_nds fullscreen_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('indoor_block_cpm__title')
          } qw(indoor_block_cpm_partner_w_nds indoor_block_cpm_partner_wo_nds indoor_block_cpm_all_w_nds indoor_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('outdoor_block_cpm__title')
          } qw(outdoor_block_cpm_partner_w_nds outdoor_block_cpm_partner_wo_nds outdoor_block_cpm_all_w_nds outdoor_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('content_block_cpm__title')
          } qw(content_block_cpm_partner_w_nds content_block_cpm_partner_wo_nds content_block_cpm_all_w_nds content_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('natural_block_cpm__title')
          } qw(natural_block_cpm_partner_w_nds natural_block_cpm_partner_wo_nds natural_block_cpm_all_w_nds natural_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('rtb_block_cpm__title')
          } qw(rtb_block_cpm_partner_w_nds rtb_block_cpm_partner_wo_nds rtb_block_cpm_all_w_nds rtb_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mobile_rtb_block_cpm__title')
          } qw(mobile_rtb_block_cpm_partner_w_nds mobile_rtb_block_cpm_partner_wo_nds mobile_rtb_block_cpm_all_w_nds mobile_rtb_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('ssp_mobile_rtb_block_cpm__title')
          } qw(ssp_mobile_rtb_block_cpm_partner_w_nds ssp_mobile_rtb_block_cpm_partner_wo_nds ssp_mobile_rtb_block_cpm_all_w_nds ssp_mobile_rtb_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('adblock_block_cpm__title')
          } qw(adblock_block_cpm_partner_w_nds adblock_block_cpm_partner_wo_nds adblock_block_cpm_all_w_nds adblock_block_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('premium_cpm__title')
          } qw(premium_cpm_partner_w_nds premium_cpm_partner_wo_nds premium_cpm_all_w_nds premium_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_context_cpm__title')
          } qw(direct_context_cpm_direct_context_partner_w_nds direct_context_cpm_direct_context_partner_wo_nds direct_context_cpm_direct_context_all_w_nds direct_context_cpm_direct_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_search_cpm__title')
          } qw(direct_search_cpm_direct_search_partner_w_nds direct_search_cpm_direct_search_partner_wo_nds direct_search_cpm_direct_search_all_w_nds direct_search_cpm_direct_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mcb_context_cpm__title')
          } qw(mcb_context_cpm_mcb_context_partner_w_nds mcb_context_cpm_mcb_context_partner_wo_nds mcb_context_cpm_mcb_context_all_w_nds mcb_context_cpm_mcb_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('mcb_search_cpm__title')
          } qw(mcb_search_cpm_mcb_search_partner_w_nds mcb_search_cpm_mcb_search_partner_wo_nds mcb_search_cpm_mcb_search_all_w_nds mcb_search_cpm_mcb_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_context_cpm__title')
          } qw(market_context_cpm_market_context_partner_w_nds market_context_cpm_market_context_partner_wo_nds market_context_cpm_market_context_all_w_nds market_context_cpm_market_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_api_context_cpm__title')
          } qw(market_api_context_cpm_market_api_context_partner_w_nds market_api_context_cpm_market_api_context_partner_wo_nds market_api_context_cpm_market_api_context_all_w_nds market_api_context_cpm_market_api_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_search_cpm__title')
          } qw(market_search_cpm_market_search_partner_w_nds market_search_cpm_market_search_partner_wo_nds market_search_cpm_market_search_all_w_nds market_search_cpm_market_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_api_search_cpm__title')
          } qw(market_api_search_cpm_market_api_search_partner_w_nds market_api_search_cpm_market_api_search_partner_wo_nds market_api_search_cpm_market_api_search_all_w_nds market_api_search_cpm_market_api_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('stripe_cpm__title')
          } qw(stripe_cpm_partner_w_nds stripe_cpm_partner_wo_nds stripe_cpm_all_w_nds stripe_cpm_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('DSP CPM')
          } qw(dsp_cpm_charging_w_nds dsp_cpm_charging_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('premium_cpc__title')
          } qw(premium_cpc_partner_w_nds premium_cpc_partner_wo_nds premium_cpc_all_w_nds premium_cpc_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_context_cpc__title')
          } qw(direct_context_cpc_direct_context_partner_w_nds direct_context_cpc_direct_context_partner_wo_nds direct_context_cpc_direct_context_all_w_nds direct_context_cpc_direct_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('direct_search_cpc__title')
          } qw(direct_search_cpc_direct_search_partner_w_nds direct_search_cpc_direct_search_partner_wo_nds direct_search_cpc_direct_search_all_w_nds direct_search_cpc_direct_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_context_cpc__title')
          } qw(market_context_cpc_market_context_partner_w_nds market_context_cpc_market_context_partner_wo_nds market_context_cpc_market_context_all_w_nds market_context_cpc_market_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_api_context_cpc__title')
          } qw(market_api_context_cpc_market_api_context_partner_w_nds market_api_context_cpc_market_api_context_partner_wo_nds market_api_context_cpc_market_api_context_all_w_nds market_api_context_cpc_market_api_context_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_search_cpc__title')
          } qw(market_search_cpc_market_search_partner_w_nds market_search_cpc_market_search_partner_wo_nds market_search_cpc_market_search_all_w_nds market_search_cpc_market_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('market_api_search_cpc__title')
          } qw(market_api_search_cpc_market_api_search_partner_w_nds market_api_search_cpc_market_api_search_partner_wo_nds market_api_search_cpc_market_api_search_all_w_nds market_api_search_cpc_market_api_search_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Stripe CPC')
          } qw(stripe_cpc_partner_w_nds stripe_cpc_partner_wo_nds stripe_cpc_all_w_nds stripe_cpc_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('Average rate')
          } qw(average_rate_all_real_price_w_nds average_rate_all_real_price_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('video_an_site_sum_partner__title')
          } qw(video_an_site_sum_partner_w_nds video_an_site_sum_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('indoor_sum_partner__title')
          } qw(indoor_sum_partner_w_nds indoor_sum_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('outdoor_sum_partner__title')
          } qw(outdoor_sum_partner_w_nds outdoor_sum_partner_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('video_an_site_sum_all__title')
          } qw(video_an_site_sum_all_w_nds video_an_site_sum_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('indoor_sum_all__title')
          } qw(indoor_sum_all_w_nds indoor_sum_all_wo_nds)
    ),
    (
        map {
            $_ => d_gettext('outdoor_sum_all__title')
          } qw(outdoor_sum_all_w_nds outdoor_sum_all_wo_nds)
    ),
    additional_income_partner => d_gettext('additional_income_partner__title'),
    (
        map {
            $_ => sub {''}
          } qw(instream_block_win_hits_unsold inpage_block_win_hits_unsold fullscreen_block_win_hits_unsold indoor_block_win_hits_unsold outdoor_block_win_hits_unsold instream_block_win_hits_own_adv inpage_block_win_hits_own_adv fullscreen_block_win_hits_own_adv indoor_block_win_hits_own_adv outdoor_block_win_hits_own_adv instream_block_win_hits inpage_block_win_hits fullscreen_block_win_hits indoor_block_win_hits outdoor_block_win_hits)
    ),
};

TRUE;
