package Application::Model::Statistics::Fields::Types;

use qbit;

use base qw(Exporter);

use Application::Model::Statistics::Fields::Metrics;

our @EXPORT    = qw(@FIELD_TYPES %FIELD_TYPES);
our @EXPORT_OK = @EXPORT;

our @FIELD_TYPES = (
    #Auction
    get_field_instream_block_metrics('instream_block_view'),

    (
        map {get_field_an_cover_hits($_)}
          qw(
          an_rtb_cover_hits
          an_content_cover_hits
          an_natural_cover_hits
          an_mobile_rtb_cover_hits
          an_ssp_mobile_rtb_cover_hits
          )
    ),

    get_field_dsp_bids('dsp_bids'),

    #Bidding
    (
        map {get_field_an_cover_hits($_)}
          qw(
          an_rtb_cover_senthits
          an_content_cover_senthits
          an_natural_cover_senthits
          an_mobile_rtb_cover_senthits
          an_ssp_mobile_rtb_cover_senthits
          )
    ),

    #Page with product requests
    get_field_an_cover_hits('an_cover_hits'),

    (
        map {get_field_hits($_)}
          qw(
          direct_search_hits
          mcb_search_hits
          market_search_hits
          premium_hits
          )
    ),

    #Page with product responses
    get_field_an_cover_hits('an_cover_senthits'),

    #Page with product shows
    (
        map {get_field_instream_block_metrics($_)}
          #Open player
          qw(instream_block_open_player),
        #preroll
        qw(
          instream_block_preroll_shows
          instream_block_preroll_hits
          instream_block_preroll_all_hits
          ),
        #postroll
        qw(
          instream_block_postroll_shows
          instream_block_postroll_hits
          instream_block_postroll_all_hits
          ),
        #midroll
        qw(
          instream_block_midroll_shows
          instream_block_midroll_hits
          instream_block_midroll_all_hits
          ),
        #pauseroll
        qw(
          instream_block_pauseroll_shows
          instream_block_pauseroll_hits
          instream_block_pauseroll_all_hits
          ),
    ),

    get_field_page_ad_shows('premium_page_ad_shows'),

    (
        map {get_field_an_cover_hits($_)}
          qw(
          an_cover_direct_hits
          an_cover_market_hits
          an_cover_mcb_hits
          )
    ),

    #Direct ad count
    (
        map {get_field_direct_ads($_)}
          qw(
          premium_ads
          direct_context_ads
          direct_search_ads
          )
    ),

    #Fraud shows/clicks
    (
        map {get_field_an_fraud($_)}
          qw(
          an_fraud_shows
          an_fraud_clicks
          )
    ),

    #Unknown order
    (
        map {get_field_an_cover_hits($_)}
          qw(
          an_rtb_cover_direct_hits
          an_content_cover_direct_hits
          an_natural_cover_direct_hits
          an_mobile_rtb_cover_direct_hits
          an_ssp_mobile_rtb_cover_direct_hits
          )
    ),

    (
        map {get_field_page_ad_shows($_)}
          qw(
          direct_context_page_ad_shows
          direct_search_page_ad_shows
          ),
    ),

    (
        map {get_field_direct_ad_metrics($_)}
          qw(
          direct_ad_visibility
          direct_ad_reach
          direct_ad_coverage
          ),
    ),

    #
    #COUNTER
    #

    #Requests

    (
        map {get_field_hits($_)}
          qw(
          instream_block_win_hits
          inpage_block_win_hits
          fullscreen_block_win_hits
          indoor_block_win_hits
          outdoor_block_win_hits
          instream_block_bad_win_hits
          inpage_block_bad_win_hits
          fullscreen_block_bad_win_hits
          indoor_block_bad_win_hits
          outdoor_block_bad_win_hits
          instream_block_hits
          inpage_block_hits
          fullscreen_block_hits
          indoor_block_hits
          outdoor_block_hits
          )
    ),
    (
        map {get_field_clicks($_)}
          qw(
          instream_block_direct_clicks
          inpage_block_direct_clicks
          fullscreen_block_direct_clicks
          indoor_block_direct_clicks
          outdoor_block_direct_clicks
          )
    ),

    (
        map {get_field_hits($_)}
          qw(
          video_bk_hits
          rtb_block_hits
          rtb_block_bad_win_hits
          content_block_hits
          natural_block_hits
          content_block_bad_win_hits
          natural_block_bad_win_hits
          mobile_rtb_block_hits
          mobile_rtb_block_bad_win_hits
          mobile_mediation_block_hits
          direct_context_hits
          mcb_context_hits
          market_context_hits
          stripe_hits
          ssp_mobile_rtb_block_hits
          adblock_block_hits
          )
    ),

    #Shows
    (
        map {get_field_shows($_)}
          qw(
          instream_block_shows
          inpage_block_shows
          fullscreen_block_shows
          indoor_block_shows
          outdoor_block_shows
          instream_block_bad_shows
          inpage_block_bad_shows
          fullscreen_block_bad_shows
          indoor_block_bad_shows
          outdoor_block_bad_shows
          instream_block_direct_shows
          inpage_block_direct_shows
          fullscreen_block_direct_shows
          indoor_block_direct_shows
          outdoor_block_direct_shows
          video_bk_shows
          content_block_shows
          natural_block_shows
          content_block_bad_shows
          natural_block_bad_shows
          content_block_direct_shows
          natural_block_direct_shows
          rtb_block_shows
          rtb_block_bad_shows
          rtb_block_direct_shows
          mobile_rtb_block_shows
          mobile_rtb_block_bad_shows
          mobile_rtb_block_direct_shows
          mobile_mediation_block_impressions
          premium_shows
          direct_context_shows
          direct_search_shows
          mcb_context_shows
          mcb_search_shows
          market_context_shows
          market_api_context_shows
          market_search_shows
          market_api_search_shows
          stripe_shows
          ssp_mobile_rtb_block_shows
          adblock_block_shows
          dsp_shows
          )
    ),

    #Clicks
    (
        map {get_field_clicks($_)}
          qw(
          content_block_direct_clicks
          natural_block_direct_clicks
          rtb_block_direct_clicks
          mobile_rtb_block_direct_clicks
          premium_clicks
          direct_context_clicks
          direct_search_clicks
          mcb_context_clicks
          mcb_search_clicks
          market_context_clicks
          market_api_context_clicks
          market_search_clicks
          market_api_search_clicks
          stripe_clicks
          )
    ),

    #Requests its adv
    (
        map {get_field_hits($_)}
          qw(
          instream_block_win_hits_own_adv
          inpage_block_win_hits_own_adv
          fullscreen_block_win_hits_own_adv
          indoor_block_win_hits_own_adv
          outdoor_block_win_hits_own_adv
          instream_block_bad_win_hits_own_adv
          inpage_block_bad_win_hits_own_adv
          fullscreen_block_bad_win_hits_own_adv
          indoor_block_bad_win_hits_own_adv
          outdoor_block_bad_win_hits_own_adv
          instream_block_hits_own_adv
          inpage_block_hits_own_adv
          fullscreen_block_hits_own_adv
          indoor_block_hits_own_adv
          outdoor_block_hits_own_adv
          video_bk_hits_own_adv
          content_block_hits_own_adv
          natural_block_hits_own_adv
          content_block_bad_win_hits_own_adv
          natural_block_bad_win_hits_own_adv
          rtb_block_hits_own_adv
          rtb_block_bad_win_hits_own_adv
          mobile_rtb_block_hits_own_adv
          mobile_rtb_block_bad_win_hits_own_adv
          ssp_mobile_rtb_block_hits_own_adv
          adblock_block_hits_own_adv
          )
    ),

    #Shows its adv
    (
        map {get_field_shows($_)}
          qw(
          instream_block_shows_own_adv
          inpage_block_shows_own_adv
          fullscreen_block_shows_own_adv
          indoor_block_shows_own_adv
          outdoor_block_shows_own_adv
          instream_block_bad_shows_own_adv
          inpage_block_bad_shows_own_adv
          fullscreen_block_bad_shows_own_adv
          indoor_block_bad_shows_own_adv
          outdoor_block_bad_shows_own_adv
          video_bk_shows_own_adv
          content_block_shows_own_adv
          natural_block_shows_own_adv
          content_block_bad_shows_own_adv
          natural_block_bad_shows_own_adv
          rtb_block_shows_own_adv
          rtb_block_bad_shows_own_adv
          mobile_rtb_block_shows_own_adv
          mobile_rtb_block_bad_shows_own_adv
          adblock_block_shows_own_adv
          )
    ),

    #Requests unsold
    (
        map {get_field_hits($_)}
          qw(
          instream_block_win_hits_unsold
          inpage_block_win_hits_unsold
          fullscreen_block_win_hits_unsold
          indoor_block_win_hits_unsold
          outdoor_block_win_hits_unsold
          instream_block_bad_win_hits_unsold
          inpage_block_bad_win_hits_unsold
          fullscreen_block_bad_win_hits_unsold
          indoor_block_bad_win_hits_unsold
          outdoor_block_bad_win_hits_unsold
          instream_block_hits_unsold
          inpage_block_hits_unsold
          fullscreen_block_hits_unsold
          indoor_block_hits_unsold
          outdoor_block_hits_unsold
          video_bk_hits_unsold
          content_block_hits_unsold
          natural_block_hits_unsold
          content_block_bad_win_hits_unsold
          natural_block_bad_win_hits_unsold
          rtb_block_hits_unsold
          rtb_block_bad_win_hits_unsold
          mobile_rtb_block_hits_unsold
          mobile_rtb_block_bad_win_hits_unsold
          ssp_mobile_rtb_block_hits_unsold
          adblock_block_hits_unsold
          )
    ),

    #
    # SUM
    #

    (
        map {get_field_all_metrics($_)}
          qw(
          video_an_site_all_hits
          video_an_site_all_shows
          video_an_site_all_hits_own_adv
          video_an_site_all_shows_own_adv
          video_an_site_all_hits_unsold
          instream_block_all_hits
          inpage_block_all_hits
          fullscreen_block_all_hits
          video_an_site_sum_all_hits
          indoor_block_all_hits
          outdoor_block_all_hits
          )
    ),

    get_field_hits('video_bk_all_hits'),

    (
        map {get_field_all_metrics($_)}
          qw(
          content_block_all_hits
          natural_block_all_hits
          rtb_block_all_hits
          mobile_rtb_block_all_hits
          ssp_mobile_rtb_block_all_hits
          adblock_block_all_hits
          )
    ),

    get_field_hits('all_hits'),

    #
    #CALCULATED
    #

    (
        map {get_field_bad_metric_percent($_)}
          #percent fraud requests
          qw(
          inpage_block_bad_win_hits_percent
          instream_block_bad_win_hits_percent
          fullscreen_block_bad_win_hits_percent
          indoor_block_bad_win_hits_percent
          outdoor_block_bad_win_hits_percent
          content_block_bad_win_hits_percent
          natural_block_bad_win_hits_percent
          rtb_block_bad_win_hits_percent
          mobile_rtb_block_bad_win_hits_percent
          ),
        #percent fraud shows
        qw(
          inpage_block_bad_shows_percent
          instream_block_bad_shows_percent
          fullscreen_block_bad_shows_percent
          indoor_block_bad_shows_percent
          outdoor_block_bad_shows_percent
          content_block_bad_shows_percent
          natural_block_bad_shows_percent
          rtb_block_bad_shows_percent
          mobile_rtb_block_bad_shows_percent
          )
    ),

    #winrate
    (
        map {get_field_winrate($_)}
          qw(
          instream_block_winrate
          inpage_block_winrate
          fullscreen_block_winrate
          indoor_block_winrate
          outdoor_block_winrate
          content_block_winrate
          natural_block_winrate
          rtb_block_winrate
          mobile_rtb_block_winrate
          ssp_mobile_rtb_block_winrate
          adblock_block_winrate
          )
    ),

    #visibility
    (
        map {get_field_visibility($_)}
          qw(
          instream_block_visibility
          inpage_block_visibility
          fullscreen_block_visibility
          indoor_block_visibility
          outdoor_block_visibility
          content_block_visibility
          natural_block_visibility
          rtb_block_visibility
          mobile_rtb_block_visibility
          mobile_mediation_block_visibility
          ssp_mobile_rtb_block_visibility
          adblock_block_visibility
          )
    ),

    #cover ratio
    (
        map {get_field_cover_ratio($_)}
          qw(
          instream_block_preroll_cover_ratio
          instream_block_postroll_cover_ratio
          instream_block_midroll_cover_ratio
          instream_block_pauseroll_cover_ratio
          instream_block_cover_ratio
          inpage_block_cover_ratio
          fullscreen_block_cover_ratio
          indoor_block_cover_ratio
          outdoor_block_cover_ratio
          content_block_cover_ratio
          natural_block_cover_ratio
          rtb_block_cover_ratio
          mobile_rtb_block_cover_ratio
          ssp_mobile_rtb_block_cover_ratio
          adblock_block_cover_ratio
          )
    ),

    #conversion
    (
        map {get_field_conversion_percent($_)}
          qw(
          instream_block_preroll_conversion_percent
          instream_block_postroll_conversion_percent
          instream_block_midroll_conversion_percent
          instream_block_pauseroll_conversion_percent
          )
    ),

    #ctr
    (
        map {get_field_ctr($_)}
          qw(
          instream_block_ctr
          instream_block_direct_ctr
          inpage_block_direct_ctr
          fullscreen_block_direct_ctr
          indoor_block_direct_ctr
          outdoor_block_direct_ctr
          content_block_direct_ctr
          natural_block_direct_ctr
          rtb_block_direct_ctr
          mobile_rtb_block_direct_ctr
          premium_ctr
          direct_context_ctr
          direct_search_ctr
          mcb_context_ctr
          mcb_search_ctr
          market_context_ctr
          market_api_context_ctr
          market_search_ctr
          market_api_search_ctr
          stripe_ctr
          )
    ),

    #
    #CALCULATED_WITH_MONEY
    #

    #Precent fraud turnover
    (
        map {get_field_percent_money($_)}
          qw(
          percent_content_bad_win_price_content_all_w_nds
          percent_content_bad_win_price_content_all_wo_nds
          percent_content_bad_win_partner_price_content_partner_w_nds
          percent_content_bad_win_partner_price_content_partner_wo_nds
          percent_natural_bad_win_price_natural_all_w_nds
          percent_natural_bad_win_price_natural_all_wo_nds
          percent_natural_bad_win_partner_price_natural_partner_w_nds
          percent_natural_bad_win_partner_price_natural_partner_wo_nds
          percent_rtb_bad_win_price_rtb_all_w_nds
          percent_rtb_bad_win_price_rtb_all_wo_nds
          percent_rtb_bad_win_partner_price_rtb_partner_w_nds
          percent_rtb_bad_win_partner_price_rtb_partner_wo_nds
          percent_mobile_rtb_bad_win_price_mobile_rtb_all_w_nds
          percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds
          percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_w_nds
          percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds
          )
    ),

    #rpm (он же cpmh для продуктов типа: Директ)
    (
        map {get_field_cpmh($_)}
          qw(
          premium_cpmh_all_w_nds
          premium_cpmh_all_wo_nds
          premium_cpmh_partner_w_nds
          premium_cpmh_partner_wo_nds
          direct_search_cpmh_direct_search_all_w_nds
          direct_search_cpmh_direct_search_all_wo_nds
          direct_search_cpmh_direct_search_partner_w_nds
          direct_search_cpmh_direct_search_partner_wo_nds
          mcb_context_cpmh_mcb_context_all_w_nds
          mcb_context_cpmh_mcb_context_all_wo_nds
          mcb_context_cpmh_mcb_context_partner_w_nds
          mcb_context_cpmh_mcb_context_partner_wo_nds
          market_context_cpmh_market_context_all_w_nds
          market_context_cpmh_market_context_all_wo_nds
          market_context_cpmh_market_context_partner_w_nds
          market_context_cpmh_market_context_partner_wo_nds
          mcb_search_cpmh_mcb_search_all_w_nds
          mcb_search_cpmh_mcb_search_all_wo_nds
          mcb_search_cpmh_mcb_search_partner_w_nds
          mcb_search_cpmh_mcb_search_partner_wo_nds
          market_search_cpmh_market_search_all_w_nds
          market_search_cpmh_market_search_all_wo_nds
          market_search_cpmh_market_search_partner_w_nds
          market_search_cpmh_market_search_partner_wo_nds
          )
    ),

    (
        map {get_field_rpm($_)}
          qw(
          content_block_rpm_all_w_nds
          natural_block_rpm_all_w_nds
          content_block_rpm_all_wo_nds
          natural_block_rpm_all_wo_nds
          content_block_rpm_partner_w_nds
          natural_block_rpm_partner_w_nds
          content_block_rpm_partner_wo_nds
          natural_block_rpm_partner_wo_nds
          rtb_block_rpm_all_w_nds
          rtb_block_rpm_all_wo_nds
          rtb_block_rpm_partner_w_nds
          rtb_block_rpm_partner_wo_nds
          mobile_rtb_block_rpm_all_w_nds
          mobile_rtb_block_rpm_all_wo_nds
          mobile_rtb_block_rpm_partner_w_nds
          mobile_rtb_block_rpm_partner_wo_nds
          ssp_mobile_rtb_block_rpm_all_w_nds
          ssp_mobile_rtb_block_rpm_all_wo_nds
          ssp_mobile_rtb_block_rpm_partner_w_nds
          ssp_mobile_rtb_block_rpm_partner_wo_nds
          adblock_block_rpm_all_w_nds
          adblock_block_rpm_all_wo_nds
          adblock_block_rpm_partner_w_nds
          adblock_block_rpm_partner_wo_nds
          )
    ),

    (
        map {get_field_cpmh($_)}
          qw(
          direct_context_cpmh_direct_context_all_w_nds
          direct_context_cpmh_direct_context_all_wo_nds
          direct_context_cpmh_direct_context_partner_w_nds
          direct_context_cpmh_direct_context_partner_wo_nds
          stripe_cpmh_all_w_nds
          stripe_cpmh_all_wo_nds
          stripe_cpmh_partner_w_nds
          stripe_cpmh_partner_wo_nds
          )
    ),

    #cpmh (ecpm в интерфейсе)
    (
        map {get_field_cpmh($_)}
          qw(
          instream_block_cpmh_all_w_nds
          instream_block_cpmh_all_wo_nds
          instream_block_cpmh_partner_w_nds
          instream_block_cpmh_partner_wo_nds
          inpage_block_cpmh_all_w_nds
          inpage_block_cpmh_all_wo_nds
          inpage_block_cpmh_partner_w_nds
          inpage_block_cpmh_partner_wo_nds
          fullscreen_block_cpmh_all_w_nds
          fullscreen_block_cpmh_all_wo_nds
          fullscreen_block_cpmh_partner_w_nds
          fullscreen_block_cpmh_partner_wo_nds
          indoor_block_cpmh_all_w_nds
          indoor_block_cpmh_all_wo_nds
          indoor_block_cpmh_partner_w_nds
          indoor_block_cpmh_partner_wo_nds
          outdoor_block_cpmh_all_w_nds
          outdoor_block_cpmh_all_wo_nds
          outdoor_block_cpmh_partner_w_nds
          outdoor_block_cpmh_partner_wo_nds
          content_block_cpmh_all_w_nds
          natural_block_cpmh_all_w_nds
          content_block_cpmh_all_wo_nds
          natural_block_cpmh_all_wo_nds
          content_block_cpmh_partner_w_nds
          natural_block_cpmh_partner_w_nds
          content_block_cpmh_partner_wo_nds
          natural_block_cpmh_partner_wo_nds
          rtb_block_cpmh_all_w_nds
          rtb_block_cpmh_all_wo_nds
          rtb_block_cpmh_partner_w_nds
          rtb_block_cpmh_partner_wo_nds
          mobile_rtb_block_cpmh_all_w_nds
          mobile_rtb_block_cpmh_all_wo_nds
          mobile_rtb_block_cpmh_partner_w_nds
          mobile_rtb_block_cpmh_partner_wo_nds
          ssp_mobile_rtb_block_cpmh_all_w_nds
          ssp_mobile_rtb_block_cpmh_all_wo_nds
          ssp_mobile_rtb_block_cpmh_partner_w_nds
          ssp_mobile_rtb_block_cpmh_partner_wo_nds
          adblock_block_cpmh_all_w_nds
          adblock_block_cpmh_all_wo_nds
          adblock_block_cpmh_partner_w_nds
          adblock_block_cpmh_partner_wo_nds
          )
    ),

    #cpm
    (
        map {get_field_cpm($_)}
          qw(
          instream_block_cpm_all_w_nds
          instream_block_cpm_all_wo_nds
          instream_block_cpm_partner_w_nds
          instream_block_cpm_partner_wo_nds
          inpage_block_cpm_all_w_nds
          inpage_block_cpm_all_wo_nds
          inpage_block_cpm_partner_w_nds
          inpage_block_cpm_partner_wo_nds
          fullscreen_block_cpm_all_w_nds
          fullscreen_block_cpm_all_wo_nds
          fullscreen_block_cpm_partner_w_nds
          fullscreen_block_cpm_partner_wo_nds
          indoor_block_cpm_all_w_nds
          indoor_block_cpm_all_wo_nds
          indoor_block_cpm_partner_w_nds
          indoor_block_cpm_partner_wo_nds
          outdoor_block_cpm_all_w_nds
          outdoor_block_cpm_all_wo_nds
          outdoor_block_cpm_partner_w_nds
          outdoor_block_cpm_partner_wo_nds
          content_block_cpm_all_w_nds
          natural_block_cpm_all_w_nds
          content_block_cpm_all_wo_nds
          natural_block_cpm_all_wo_nds
          content_block_cpm_partner_w_nds
          natural_block_cpm_partner_w_nds
          content_block_cpm_partner_wo_nds
          natural_block_cpm_partner_wo_nds
          rtb_block_cpm_all_w_nds
          rtb_block_cpm_all_wo_nds
          rtb_block_cpm_partner_w_nds
          rtb_block_cpm_partner_wo_nds
          mobile_rtb_block_cpm_all_w_nds
          mobile_rtb_block_cpm_all_wo_nds
          mobile_rtb_block_cpm_partner_w_nds
          mobile_rtb_block_cpm_partner_wo_nds
          ssp_mobile_rtb_block_cpm_all_w_nds
          ssp_mobile_rtb_block_cpm_all_wo_nds
          ssp_mobile_rtb_block_cpm_partner_w_nds
          ssp_mobile_rtb_block_cpm_partner_wo_nds
          adblock_block_cpm_all_w_nds
          adblock_block_cpm_all_wo_nds
          adblock_block_cpm_partner_w_nds
          adblock_block_cpm_partner_wo_nds
          premium_cpm_all_w_nds
          premium_cpm_all_wo_nds
          premium_cpm_partner_w_nds
          premium_cpm_partner_wo_nds
          direct_context_cpm_direct_context_all_w_nds
          direct_context_cpm_direct_context_all_wo_nds
          direct_context_cpm_direct_context_partner_w_nds
          direct_context_cpm_direct_context_partner_wo_nds
          direct_search_cpm_direct_search_all_w_nds
          direct_search_cpm_direct_search_all_wo_nds
          direct_search_cpm_direct_search_partner_w_nds
          direct_search_cpm_direct_search_partner_wo_nds
          mcb_context_cpm_mcb_context_all_w_nds
          mcb_context_cpm_mcb_context_all_wo_nds
          mcb_context_cpm_mcb_context_partner_w_nds
          mcb_context_cpm_mcb_context_partner_wo_nds
          mcb_search_cpm_mcb_search_all_w_nds
          mcb_search_cpm_mcb_search_all_wo_nds
          mcb_search_cpm_mcb_search_partner_w_nds
          mcb_search_cpm_mcb_search_partner_wo_nds
          market_context_cpm_market_context_all_w_nds
          market_context_cpm_market_context_all_wo_nds
          market_context_cpm_market_context_partner_w_nds
          market_context_cpm_market_context_partner_wo_nds
          market_api_context_cpm_market_api_context_all_w_nds
          market_api_context_cpm_market_api_context_all_wo_nds
          market_api_context_cpm_market_api_context_partner_w_nds
          market_api_context_cpm_market_api_context_partner_wo_nds
          market_search_cpm_market_search_all_w_nds
          market_search_cpm_market_search_all_wo_nds
          market_search_cpm_market_search_partner_w_nds
          market_search_cpm_market_search_partner_wo_nds
          market_api_search_cpm_market_api_search_all_w_nds
          market_api_search_cpm_market_api_search_all_wo_nds
          market_api_search_cpm_market_api_search_partner_w_nds
          market_api_search_cpm_market_api_search_partner_wo_nds
          stripe_cpm_all_w_nds
          stripe_cpm_all_wo_nds
          stripe_cpm_partner_w_nds
          stripe_cpm_partner_wo_nds
          dsp_cpm_charging_w_nds
          dsp_cpm_charging_wo_nds
          )
    ),

    #cpc
    (
        map {get_field_cpc($_)}
          qw(
          premium_cpc_all_w_nds
          premium_cpc_all_wo_nds
          premium_cpc_partner_w_nds
          premium_cpc_partner_wo_nds
          direct_context_cpc_direct_context_all_w_nds
          direct_context_cpc_direct_context_all_wo_nds
          direct_context_cpc_direct_context_partner_w_nds
          direct_context_cpc_direct_context_partner_wo_nds
          direct_search_cpc_direct_search_all_w_nds
          direct_search_cpc_direct_search_all_wo_nds
          direct_search_cpc_direct_search_partner_w_nds
          direct_search_cpc_direct_search_partner_wo_nds
          market_context_cpc_market_context_all_w_nds
          market_context_cpc_market_context_all_wo_nds
          market_context_cpc_market_context_partner_w_nds
          market_context_cpc_market_context_partner_wo_nds
          market_api_context_cpc_market_api_context_all_w_nds
          market_api_context_cpc_market_api_context_all_wo_nds
          market_api_context_cpc_market_api_context_partner_w_nds
          market_api_context_cpc_market_api_context_partner_wo_nds
          market_search_cpc_market_search_all_w_nds
          market_search_cpc_market_search_all_wo_nds
          market_search_cpc_market_search_partner_w_nds
          market_search_cpc_market_search_partner_wo_nds
          market_api_search_cpc_market_api_search_all_w_nds
          market_api_search_cpc_market_api_search_all_wo_nds
          market_api_search_cpc_market_api_search_partner_w_nds
          market_api_search_cpc_market_api_search_partner_wo_nds
          stripe_cpc_all_w_nds
          stripe_cpc_all_wo_nds
          stripe_cpc_partner_w_nds
          stripe_cpc_partner_wo_nds
          )
    ),

    #average rate
    (
        map {get_field_average_rate($_)}
          qw(
          average_rate_all_real_price_w_nds
          average_rate_all_real_price_wo_nds
          )
    ),

    #
    #MONEY
    #

    (
        map {get_field_money($_)}
          qw(
          adblock_all_w_nds
          adblock_all_wo_nds
          adblock_partner_w_nds
          adblock_partner_wo_nds
          all_real_price_w_nds
          all_real_price_wo_nds
          all_w_nds
          all_wo_nds
          bad_win_partner_price_w_nds
          bad_win_partner_price_wo_nds
          bad_win_price_w_nds
          bad_win_price_wo_nds
          bk_partner_price_w_nds
          bk_partner_price_wo_nds
          bk_price_w_nds
          bk_price_wo_nds
          charging_w_nds
          charging_wo_nds
          content_all_w_nds
          content_all_wo_nds
          content_bad_win_partner_price_w_nds
          content_bad_win_partner_price_wo_nds
          content_bad_win_price_w_nds
          content_bad_win_price_wo_nds
          content_partner_w_nds
          content_partner_wo_nds
          natural_all_w_nds
          natural_all_wo_nds
          natural_bad_win_partner_price_w_nds
          natural_bad_win_partner_price_wo_nds
          natural_bad_win_price_w_nds
          natural_bad_win_price_wo_nds
          natural_partner_w_nds
          natural_partner_wo_nds

          direct_context_all_w_nds
          direct_context_all_wo_nds
          direct_context_partner_w_nds
          direct_context_partner_wo_nds
          direct_search_all_w_nds
          direct_search_all_wo_nds
          direct_search_partner_w_nds
          direct_search_partner_wo_nds
          dsp_charging_w_nds
          dsp_charging_wo_nds
          fullscreen_all_w_nds
          fullscreen_all_wo_nds
          fullscreen_bad_win_partner_price_w_nds
          fullscreen_bad_win_partner_price_wo_nds
          fullscreen_bad_win_price_w_nds
          fullscreen_bad_win_price_wo_nds
          fullscreen_partner_w_nds
          fullscreen_partner_wo_nds
          inpage_all_w_nds
          inpage_all_wo_nds
          inpage_bad_win_partner_price_w_nds
          inpage_bad_win_partner_price_wo_nds
          inpage_bad_win_price_w_nds
          inpage_bad_win_price_wo_nds
          inpage_partner_w_nds
          inpage_partner_wo_nds
          instream_all_w_nds
          instream_all_wo_nds
          instream_bad_win_partner_price_w_nds
          instream_bad_win_partner_price_wo_nds
          instream_bad_win_price_w_nds
          instream_bad_win_price_wo_nds
          instream_partner_w_nds
          instream_partner_wo_nds
          indoor_all_w_nds
          indoor_all_wo_nds
          indoor_bad_win_partner_price_w_nds
          indoor_bad_win_partner_price_wo_nds
          indoor_bad_win_price_w_nds
          indoor_bad_win_price_wo_nds
          indoor_partner_w_nds
          indoor_partner_wo_nds
          outdoor_all_w_nds
          outdoor_all_wo_nds
          outdoor_bad_win_partner_price_w_nds
          outdoor_bad_win_partner_price_wo_nds
          outdoor_bad_win_price_w_nds
          outdoor_bad_win_price_wo_nds
          outdoor_partner_w_nds
          outdoor_partner_wo_nds
          market_api_context_all_w_nds
          market_api_context_all_wo_nds
          market_api_context_partner_w_nds
          market_api_context_partner_wo_nds
          market_api_search_all_w_nds
          market_api_search_all_wo_nds
          market_api_search_partner_w_nds
          market_api_search_partner_wo_nds
          market_context_all_w_nds
          market_context_all_wo_nds
          market_context_partner_w_nds
          market_context_partner_wo_nds
          market_search_all_w_nds
          market_search_all_wo_nds
          market_search_partner_w_nds
          market_search_partner_wo_nds
          mcb_context_all_w_nds
          mcb_context_all_wo_nds
          mcb_context_partner_w_nds
          mcb_context_partner_wo_nds
          mcb_search_all_w_nds
          mcb_search_all_wo_nds
          mcb_search_partner_w_nds
          mcb_search_partner_wo_nds
          mobile_rtb_all_w_nds
          mobile_rtb_all_wo_nds
          mobile_rtb_bad_win_partner_price_w_nds
          mobile_rtb_bad_win_partner_price_wo_nds
          mobile_rtb_bad_win_price_w_nds
          mobile_rtb_bad_win_price_wo_nds
          mobile_rtb_partner_w_nds
          mobile_rtb_partner_wo_nds
          partner_w_nds
          partner_wo_nds
          premium_all_w_nds
          premium_all_wo_nds
          premium_partner_w_nds
          premium_partner_wo_nds
          rs_all_w_nds
          rs_all_wo_nds
          rtb_all_w_nds
          rtb_all_wo_nds
          rtb_bad_win_partner_price_w_nds
          rtb_bad_win_partner_price_wo_nds
          rtb_bad_win_price_w_nds
          rtb_bad_win_price_wo_nds
          rtb_partner_w_nds
          rtb_partner_wo_nds
          ssp_context_rtb_all_w_nds
          ssp_context_rtb_all_wo_nds
          ssp_context_rtb_partner_w_nds
          ssp_context_rtb_partner_wo_nds
          ssp_mobile_rtb_all_w_nds
          ssp_mobile_rtb_all_wo_nds
          ssp_mobile_rtb_partner_w_nds
          ssp_mobile_rtb_partner_wo_nds
          stripe_all_w_nds
          stripe_all_wo_nds
          stripe_partner_w_nds
          stripe_partner_wo_nds
          additional_income_partner_wo_nds
          mobile_mediation_block_calculated_revenue_original
          )
    ),
    (
        map {get_field_money_with_currency($_)}
          qw(
          mobile_mediation_block_calculated_revenue
          )
    ),
    (
        map {get_field_video_sum_money($_)}
          qw(
          video_an_site_sum_partner_w_nds
          video_an_site_sum_partner_wo_nds
          video_an_site_sum_all_w_nds
          video_an_site_sum_all_wo_nds
          )
    ),
);

our %FIELD_TYPES = map {$_->{'id'} => $_} @FIELD_TYPES;

TRUE;
