package Application::Model::Statistics::Hierarchy;

use qbit;

use base qw(Application::Model::Statistics::Product);

__PACKAGE__->abstract_methods(qw(children));
__PACKAGE__->model_accessors(product_manager => 'Application::Model::ProductManager',);

sub available_children {
    my ($self) = @_;

    return grep {$_->is_available()} $self->children();
}

sub data_query {
    my ($self, %opts) = @_;

    my @queries = ();

    $opts{'data_query_top_level_id'} //= $self->id;
    $opts{'entity_filter_accessor'} //= ($self->can('product') ? $self->product : $self->users)->{'accessor'};

    if ($self->_can('query')) {
        my $query = $self->SUPER::data_query(%opts);

        push(@queries, $query) if defined($query);
    }

    foreach my $child ($self->available_children()) {
        push(@queries, $child->data_query(%opts));
    }

    return @queries;
}

sub fields {{}}

sub fields_intersection {
    my @children_fields = @_;

    return $children_fields[0] if @children_fields == 1;

    my %fields = map {$_ => 1} @{
        arrays_intersection(
            map {
                my $f = $_;
                [map {$_->{'id'}} @$f]
              } @children_fields
        )
      };

    return [grep {$fields{$_->{'id'}}} @{$children_fields[0]}];
}

sub fields_union {
    my @children_fields = @_;

    return $children_fields[0] if @children_fields == 1;

    my %fields = ();

    return [
        grep {$_->{'shared'} && $fields{$_->{'id'}}++ == 0 || $fields{$_->{'id'}}++ == 0}
        map {@$_} @children_fields
    ];
}

sub get_conflict_fields {
    my ($self, @children) = @_;

    my %group_fields = map {$_->{'id'} => TRUE} @{$self->get_entity_fields()}, @{$self->get_dimension_fields()};

    my @conflict_fields      = ();
    my %hash_conflict_fields = ();

    if ($self->can('conflict_fields')) {
        push(@children, {conflict_fields => $self->conflict_fields()});
    }

    foreach my $child (@children) {
        foreach (@{$child->{'conflict_fields'}}) {
            if (($group_fields{$_->[0]} || $group_fields{$_->[1]}) && !$hash_conflict_fields{$_->[0] . '=' . $_->[1]}) {
                push(@conflict_fields, $_);
                $hash_conflict_fields{$_->[0] . '=' . $_->[1]} = TRUE;
                $hash_conflict_fields{$_->[1] . '=' . $_->[0]} = TRUE;
            }
        }
    }

    return \@conflict_fields;
}

sub get_dimension_fields {
    my ($self, %opts) = @_;

    return $self->SUPER::get_dimension_fields(%opts) if $self->_can('dimension_fields');

    return fields_intersection(map {$_->get_dimension_fields(%opts)} $self->available_children());
}

sub get_fields {
    my ($self, %opts) = @_;

    $opts{'child_fields'} //=
      fields_union(map {$_->get_fields(%opts, with_shared => TRUE)} $self->available_children());

    my $fields = $self->SUPER::get_fields(%opts, with_shared => TRUE);

    return $fields;
}

sub has_statistics {FALSE}

sub is_available {
    my ($self) = @_;

    foreach ($self->children()) {
        return TRUE if $_->is_available();
    }

    return FALSE;
}

sub is_available_by_right {
    my ($self) = @_;

    foreach ($self->children()) {
        return TRUE if $_->is_available_by_right();
    }

    return FALSE;
}

TRUE;
